<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use App\Models\AppointmentModel;
use App\Http\Controllers\SpecInstController;
class AppointmentController extends Controller
{
    function Appointment(){
        return view('/appointment/view-appointment');
    }
    function viewAppointments(Request $req){
        if(!empty($req->FromDate))
            {   
                if($req->MrdNo == '' || $req->MrdNo == 0){
                    $result = AppointmentModel::whereBetween('AppDate', array($req->FromDate, $req->ToDate))->get();
                }
                else{
                    $MrdNo = $req->MrdNo;
                    $result = AppointmentModel::whereBetween('AppDate', array($req->FromDate, $req->ToDate))->where(['MrdNo'=>$MrdNo])->get();
                }
            }
            else{
                $result = AppointmentModel::all();
            }
            
        return view('/appointment/view-appointment-lists',['data'=>$result]);
    }
    function addNewAppointment(){
        $clinicnameList = (new SpecialityController)->getSpecClinicName();
        return view('/appointment/add-appointment',['clinicnameList'=>$clinicnameList]);
    }
    function saveNewAppointmnet(Request $req){
        if($req->action == 'Save'){
            $Appoint = new AppointmentModel;
        }
        else{
            $Appoint = AppointmentModel::find($req->saveid);
        }
        $Appoint->MrdNo = $req->MrdNo; 
        $Appoint->PatientName = $req->PatientName;
        $Appoint->Phone = $req->Phone;
        $Appoint->ReferFor = $req->ReferFor;
        $Appoint->Consultant = $req->Consultant;
        $Appoint->AppDate = $req->AppDate;
        $Appoint->AppTime = $req->AppTime;
        $Appoint->save();
        $AppointId = $Appoint->id;

        // $msg = "Dear ".$req->PatientName." your appointment for ".$req->ReferFor." is on ".date("d/m/Y", strtotime(str_replace('-', '/',$req->AppDate)));
        // if($req->AppTime){
        //     $msg.= " at ".$req->AppTime;
        // }
        // $msg.= " at Vyawahare Netralaya Amravati. Any Qurey please Contact 9370109617,9552731024";
        // $sms_text = strip_tags($msg);
        
        // $api_url = "https://smswaapi.in/api/send?number=91".$req->Phone."&type=text&message=".$sms_text."&instance_id=64B0F93ED3A13&access_token=649d339dbf9f2";
        // $response = file_get_contents( $api_url);
        //$character = json_decode($response,true);
        //$status = $character['status'];
        return json_encode(array('id'=>$AppointId,'Status'=>1));

    }
    function deletAppointment(Request $req){
        $data=AppointmentModel::find($req->id)->delete();
        return 1;
    }
    function checkAppointment(Request $req){
        $currdate = date('Y-m-d');
        $result = AppointmentModel::where('AppDate',$currdate)->get();
        $cnt = $result->count();
        if($cnt > 0){
            return view('/appointment/today-appointment-lists',['data'=>$result]); 
        }
        else{
            return 0;
        }
    }

    function editAppointment($id){
        $result = AppointmentModel::where('id',$id)->first();
        $clinicname = $result->ReferFor;
        $clinicnameList = (new SpecialityController)->getSpecClinicName();
        $clinicdocnameList = (new SpecialityController)->getSpecConsultant2($clinicname);
        return view('/appointment/edit-appointment',['clinicdocnameList'=>$clinicdocnameList,'clinicnameList'=>$clinicnameList,'data'=>$result]);
    }
}
