<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\CertificateModel;
use Session;

class CertificateController extends Controller
{
    function referralForm(){
        return view('/certificates/view-referral-form');
    }
    function viewReferralForm(Request $req){
      $query = DB::table('tbl_certificates as tc')
        ->leftJoin('tbl_users as tu', 'tc.Consultant', '=', 'tu.id')
        ->leftJoin('tbl_type_of_certificates as ttc', 'tc.CertificateType', '=', 'ttc.id')
        ->select('tc.*', 'tu.Name as ConsultantName','ttc.name AS CertiName');

    if (!empty($req->FromDate)) {
        $query->whereBetween('tc.CertiDate', [$req->FromDate, $req->ToDate]);

        if (!empty($req->MrdNo) && $req->MrdNo != 0) {
            $query->where('tc.MrdNo', $req->MrdNo);
        }
    }

    $result = $query->get();

    return view('/certificates/view-referral-form-lists', ['data' => $result]);
    }
    function editReferralForm($id){
        $result = CertificateModel::find($id);
        return view('/certificates/edit-referral-form',['data'=>$result]);
    }

    function addReferralForm(){
        $consultantList = (new MasterController)->consultantList();
        $certificateList = (new MasterController)->certificateList();
        return view('/certificates/add-referral-form',['consultantList' => $consultantList,'certificateList'=>$certificateList]);
    }

    function saveReferralForm(Request $req){
            if($req->action == 'Save'){
            $Consent = new CertificateModel;
            $Consent->CreatedBy=Session::get('UserId');
            $Consent->CreatedDate=date('Y-m-d H:i:s');
            $Consent->ModifiedBy=0;
            }
            else{
            $Consent = CertificateModel::find($req->saveid);
            $Consent->ModifiedBy=Session::get('UserId');
            $Consent->ModifiedDate=date('Y-m-d H:i:s');
            }
            $Consent->MrdNo=$req->MrdNo;
            $Consent->PatientName=$req->PatientName;
            $Consent->Phone=$req->Phone;
            $Consent->SufferFrom=$req->SufferFrom;
            $Consent->CertiDate=$req->CertiDate;
            $Consent->Consultant=$req->Consultant;
            $Consent->RegNo=$req->RegNo;
            $Consent->RestFrom=$req->RestFrom;
            $Consent->RestTo=$req->RestTo;
            $Consent->JoinDate=$req->JoinDate;
            $Consent->CertificateType=$req->CertificateType;
            
            
            $Consent->save();
            $RefId = $Consent->id;
           return json_encode(array('id'=>$RefId,'Status'=>1));
          
    }

function printReferralForm($id){
     $result = DB::table('tbl_certificates as tc')
        ->leftJoin('tbl_users as tu', 'tc.Consultant', '=', 'tu.id')
        ->select('tc.*', 'tu.Name as ConsultantName')
        ->where(['tc.id'=>$id])->first();
    $type = $result->CertificateType;
    if($type == 1){
return view('/certificates/print-illness-certi',['data'=>$result]);
    }
    if($type == 2){
return view('/certificates/print-fitness-certi',['data'=>$result]);
    }
    if($type == 4){
return view('/certificates/print-expenses-certi',['data'=>$result]);
    }
    if($type == 5){
return view('/certificates/print-inability-certi',['data'=>$result]);
    }

    
   
}
    function deleteCertiticate(Request $req){
        CertificateModel::find($req->id)->delete();
        return 1;
    }
    
    

   
   
}
