<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ConsultationChargesModel;
use App\Http\Controllers\MasterController;
use App\Models\ProcedureModel;
use App\Models\PatientBalanceModel;
use Session;
class ConsultationChargesController extends Controller
{
    function ConsultationCharges(){
        //$patientList = (new MasterController)->patientList();
        $today = $this->todayConsultationCharges();
        $total = $this->totalConsultationCharges();
        $procedures = ProcedureModel::where('Type',1)->get();
        $saveprocedures = DB::select("SELECT DISTINCT(Procedures) AS Procedures  FROM tbl_consultation_charges");
        
        return view('/consultation_charges/view-opd-receipt',['saveprocedures'=>$saveprocedures,'today'=>$today,'total'=>$total,'procedures'=>$procedures]);
    }

    function viewConsultationCharges(Request $req){
        $CurrDate = date('Y-m-d');
        $Procedures = $req->SrchProcedures;
        $SrchPayMode = $req->SrchPayMode;
        if(!empty($req->FromDate))
            {

                $sql = "SELECT tor.*,tp.Phone  From tbl_consultation_charges tor LEFT JOIN tbl_patients tp ON tp.MrdNo=tor.MrdNo WHERE tor.Status=1 AND tor.CreatedDate>='$req->FromDate' AND tor.CreatedDate<='$req->ToDate'";
                if($Procedures != ''){
                    $sql.= " AND tor.Procedures = '$Procedures'";
                }
                if($SrchPayMode != ''){
                    $sql.= " AND tor.PayMode = '$SrchPayMode'";
                }
                $result = DB::select($sql);

                $sql2 = "SELECT SUM(Amount) AS Amount  From tbl_consultation_charges WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($Procedures != ''){
                    $sql2.= " AND Procedures = '$Procedures'";
                }
                if($SrchPayMode != ''){
                    $sql2.= " AND PayMode = '$SrchPayMode'";
                }
                $result2 = DB::select($sql2);
                $total = $result2[0]->Amount;

                // if($Procedures==''){
                //     $result =  ConsultationChargesModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['PayMode'=>$SrchPayMode])->get();  
                // }
                // else{
                //     if($SrchPayMode == ''){
                //         $result =  ConsultationChargesModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['Procedures'=>$Procedures])->get();  
                //     }
                //     else{
                //         $result =  ConsultationChargesModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['Procedures'=>$Procedures,'PayMode'=>$SrchPayMode])->get();  
                //     }
                    
                // }
            }
            else{
                $result =  ConsultationChargesModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                //$result =  ConsultationChargesModel::select()->get();  
                $total = $result->sum('Amount');
            }

            //
            
        return view('consultation_charges/incopdreceipts',['data'=>$result,'total'=>$total]);
    }

    function fetchConsultationChargesRecord(Request $req){
        $result = ConsultationChargesModel::find($req->id);
        echo json_encode($result);
    }

    function deleteConsultationCharges(Request $req){
        ConsultationChargesModel::where(['id'=>$req->id])->delete();
        $today = $this->todayConsultationCharges();
        $total = $this->totalConsultationCharges();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveConsultationCharges(Request $req){
        $CurrDate = date('Y-m-d');
        if($req->action == 'Save'){
        $ConsultationCharges = new ConsultationChargesModel;
        }
        else{
        $ConsultationCharges = ConsultationChargesModel::find($req->id);
        }
        $ConsultationCharges->MrdNo = $req->MrdNo;
        $ConsultationCharges->PatientId = $req->PatientId;
        $ConsultationCharges->PatientName = $req->PatientName;
        $ConsultationCharges->PayMode = $req->PayMode;
        $ConsultationCharges->ChequeNo = $req->ChequeNo;
        $ConsultationCharges->Narration = $req->Narration;
        $ConsultationCharges->Procedures = $req->Procedures;
        // if($req->ProcedureId != ''){
        // $Procedure = implode(",",$req->ProcedureId);
        // $ConsultationCharges->Procedures = $Procedure;
        // }
        // $number = count($req->ProcedureChk);
        // if($number > 0){
        //     //$ProcAmount = ProcedureModel::select('Amount')->whereIn('id',array($Procedure))->sum('Amount');
        //     $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_procedures WHERE id IN($Procedure)");
        //     $ProcAmount = $result[0]->Amount;
        // }
        $ConsultationCharges->Amount = $req->Amount;
        $ConsultationCharges->ConsultantId = $req->ConsultantId;
        $ConsultationCharges->Consultant = $req->Consultant;
        $ConsultationCharges->Status = 1;
        $ConsultationCharges->CreatedBy = Session::get('UserId');
        $ConsultationCharges->CreatedDate = $req->CreatedDate;
        $ConsultationCharges->save();
        $postid = $ConsultationCharges->id;
        $today = $this->todayConsultationCharges();
        $total = $this->totalConsultationCharges();

        if($req->pageval == 'ptbal'){
            PatientBalanceModel::find($req->ptbalid)->delete();
        }
        return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayConsultationCharges(){
        $CurrDate = date('Y-m-d');
        $rncnt =  ConsultationChargesModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalConsultationCharges(){
        $rncnt =  ConsultationChargesModel::count();
        return $rncnt;
    }

    function getProcRec(Request $req){
        $result = ProcedureModel::where('Type',1)->get();
        return view('/consultation_charges/inc-opd-receipt-procedure',['data'=>$result]);
    }   

    function getProcRec2(Request $req){
        $result2 = ConsultationChargesModel::select('Procedures')->where('id',$req->id)->get();
        $Procedures = $result2[0]->Procedures;
        $result = DB::select("SELECT * FROM tbl_procedures WHERE Type=1 AND id NOT IN($Procedures)");
        //$result3 = ProcedureModel::select()->whereIn('id',[$Procedures])->get();
        $result3 = DB::select("SELECT * FROM tbl_procedures WHERE Type=1 AND id IN($Procedures)");
        //$result = DB::select("SELECT * FROM tbl_procedures WHERE id IN($Procedures)");
        return view('/consultation_charges/inc-opd-receipt-procedure2',['data2'=>$result3,'data'=>$result,'Procedures'=>$Procedures]);
    } 

    function getProcedureNames($procid){
        //return $procid;
        $result = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=1 AND id IN($procid)");
        // $result = DB::table('tbl_procedures')
        //     ->selectRaw('GROUP_CONCAT(Name) As ProcedureName')
        //     ->whereIn('id',[$procid])
        //     ->get();
        $ProcedureName = $result[0]->ProcedureName;
        return $ProcedureName;
    }

    function ConsultationChargesPrint($id){
        $result =  ConsultationChargesModel::select()->where('id',$id)->get();
        // $ProId = $result[0]->Procedures;
        // $result2 = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=1 AND id IN($ProId)");
        // $ProcedureName = $result2[0]->ProcedureName;
        $ProcedureName = $result[0]->Procedures;
        return view('/consultation_charges/opd-receipt-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function useConsultationCharges($id){
        $result =  ConsultationChargesModel::select()->whereIn('Procedures',[$id])->toSql();
        return $result;
    }
}
