<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\MasterController;
use App\Models\CounsellingModel;

class CounsellingController extends Controller
{
    function addCounselling(){
        $patientList = (new MasterController)->patientList();
        $consultantList = (new MasterController)->consultantList();
        $counsellingid = $this->getCounsellingId();
        return view('/opd/add-counselling',['patientList'=>$patientList,'counsellingid'=>$counsellingid,'consultantList'=>$consultantList]);
    }

    function getCounsellingId(){
        $data = CounsellingModel::all();
        return $data;
    }

    function getLastCounsellingId(){
        $result = CounsellingModel::select()->max('id');
        if($result == ''){
            $maxid = 1;
        }
        else{
            $maxid = $result + 1;
        }
        return $maxid;
    }

    function saveCounselling(Request $req){
        if($req->action == 'Save'){
            $Counselling = new CounsellingModel;
        }
        else{
            $Counselling = CounsellingModel::find($req->id);
        }
        $Counselling->MrdNo = $req->MrdNo; $Counselling->PatientName = $req->PatientName;
        $Counselling->Age = $req->Age; $Counselling->Gender = $req->Gender;
        $Counselling->Phone = $req->Phone; $Counselling->Address = $req->Address;
        $Counselling->City = $req->City; $Counselling->AdmissionDate = $req->AdmissionDate;
        $Counselling->CounsellingDate = $req->CounsellingDate; $Counselling->SurgeryDate = $req->SurgeryDate;
        $Counselling->Site = $req->Site; $Counselling->Diagnosis = $req->Diagnosis;
        $Counselling->SurgeryName = $req->SurgeryName; $Counselling->SurgenName = $req->SurgenName;
        $Counselling->Anaesthetist = $req->Anaesthetist;$Counselling->Status = 1;
        $Counselling->CreatedBy = 19;
        $Counselling->ModifiedBy = 19;
        $Counselling->CreatedDate = date('Y-m-d');
        $Counselling->save();
        return redirect('/counselling');
    }

    function fetchCounsellingDetails(Request $req){
        $id = $req->id;
        $data = CounsellingModel::select()->where('id',$id)->first();
        return json_encode($data);
    }

    function viewCounsellings(){
        return view('/opd/view-counsellings');
    }

    function viewCounsellingList(Request $req){
        if(!empty($req->FromDate))
            {
                $result =  CounsellingModel::select()
                ->whereBetween('SurgeryDate', array($req->FromDate, $req->ToDate))
                ->orderBy('SurgeryDate','desc')->get();
            }
            else{
        $result = CounsellingModel::all();
            }
        return view('/opd/inc-view-counselling-lists',['data'=>$result]);
    }

    function deletCounselling(Request $req){
        CounsellingModel::find($req->id)->delete();
        return 1;
    }
}
