<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\IpdMadamReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\OTModel;
use App\Models\ProcedureModel;
use Session;
class IpdMadamReceiptController extends Controller
{
    function IpdMadamReceipt(){
        $patientList = (new MasterController)->ipdPatientList();
        $today = $this->todayIpdMadamReceipt();
        $total = $this->totalIpdMadamReceipt();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/ipd/view-ipd-madam-receipt',['procedures'=>$procedures,'patientList'=>$patientList,'today'=>$today,'total'=>$total]);
    }

    function addIpdMadamReceipt($mrdno,$otid){
        $otresult = OTModel::where('id',$otid)->first();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/ipd/add-ipd-receipt',['procedures'=>$procedures,'otresult'=>$otresult]);
    }
    
    function viewIpdMadamReceipts(Request $req){

        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        if(!empty($req->FromDate))
            {

                $sql = "SELECT *  From tbl_ipd_madam_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql.= " AND PayMode = '$SrchPayMode'";
                }
                $result = DB::select($sql);

                $sql2 = "SELECT SUM(Amount) AS Amount  From tbl_ipd_madam_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql2.= " AND PayMode = '$SrchPayMode'";
                }
                $result2 = DB::select($sql2);
                $total = $result2[0]->Amount;

            }
            else{
                $result =  IpdMadamReceiptModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                $total = $result->sum('Amount');
            }
        return view('ipd/incipdmadamreceipts',['data'=>$result,'total'=>$total]);

        
    }

    function fetchIpdMadamReceiptRecord(Request $req){
        $result = IpdMadamReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteIpdMadamReceipt(Request $req){
        IpdMadamReceiptModel::where(['id'=>$req->id])->delete();
        $today = $this->todayIpdMadamReceipt();
        $total = $this->totalIpdMadamReceipt();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveIpdMadamReceipt(Request $req){
            $CurrDate = date('Y-m-d');
            if($req->action == 'Save'){
            $IpdReceipt = new IpdMadamReceiptModel;
            }
            else{
            $IpdReceipt = IpdMadamReceiptModel::find($req->id);
            }
            $IpdReceipt->MrdNo = $req->MrdNo;
            $IpdReceipt->IpdNo = $req->IpdNo;
            $IpdReceipt->PatientName = $req->PatientName;
            $IpdReceipt->Procedures = $req->Procedures;
            $IpdReceipt->Amount = $req->Amount;
            $IpdReceipt->PayMode = $req->PayMode;
            $IpdReceipt->ChequeNo = $req->ChequeNo;
            $IpdReceipt->Narration = $req->Narration;
            $IpdReceipt->AdmissionDate = $req->AdmissionDate;
            $IpdReceipt->AdmissionTime = $req->AdmissionTime;
            $IpdReceipt->DepositDate = $req->DepositDate;
            $IpdReceipt->DepositTime = $req->DepositTime;
            $IpdReceipt->ChqDate = $req->ChqDate;
            $IpdReceipt->ChqDep = $req->ChqDep;
            $IpdReceipt->Status = 1;
            $IpdReceipt->CreatedBy = 19;
            $IpdReceipt->CreatedDate = $req->CreatedDate;
            $IpdReceipt->ReceiptNo = $req->ReceiptNo;
            $IpdReceipt->save();
            $postid = $IpdReceipt->id;
            // $ReceiptNo = "MCPV".$postid;
            // IpdMadamReceiptModel::where(['id'=>$postid])->update(['ReceiptNo'=>$ReceiptNo]);     
            $today = $this->todayIpdMadamReceipt();
            $total = $this->totalIpdMadamReceipt();
            return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayIpdMadamReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt =  IpdMadamReceiptModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalIpdMadamReceipt(){
        $rncnt =  IpdMadamReceiptModel::count();
        return $rncnt;
    }

    function ipdMadamReceiptPrint($id){
        $result =  IpdMadamReceiptModel::select()->where('id',$id)->get();
        $ProcedureName = $result[0]->Procedures;
        return view('/ipd/ipd-madam-receipt-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function getIpdMadamReceiptNo(Request $req){
        $maxid = IpdMadamReceiptModel::select('id')->max('id');
        $curryr = substr(date('Y'), -2);
        $currmonth = date('m');
        if($maxid == 0 || $maxid == ''){
            $maxid = "CRVM1/".($curryr-1)."-".$curryr."/".$currmonth;
        }
        else{
            $maxid2 = $maxid + 1;
            $maxid = "CRVM".$maxid2."/".($curryr-1)."-".$curryr."/".$currmonth;
        }
        return $maxid;
       
    }
    
}