<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\MedicalCertiModel;
use App\Http\Controllers\MasterController;

class MedicalCertiController extends Controller
{
    function medicalCertificate(){
        $patientList = (new MasterController)->patientList();
        $diagnosisList = (new MasterController)->diagnosisList();
       $consultantList = (new MasterController)->consultantList();
        return view('/certificates/create-medical-certificate',['consultantList'=>$consultantList,'patientList'=>$patientList,'diagnosisList'=>$diagnosisList]);
    }

    function saveMedicalCertificate(Request $req){
        if($req->actionvalue == 'Save'){
            $MedicalCerti = new MedicalCertiModel;
        }
        else{
            $MedicalCerti = MedicalCertiModel::find($req->saveid);
        }
        
        $MedicalCerti->MrdNo = $req->MrdNo;
        $MedicalCerti->PatientName = $req->PatientName;
        $MedicalCerti->Age = $req->Age;
        $MedicalCerti->Diagnosis = $req->Diagnosis;
        $MedicalCerti->line1radio = $req->line1radio;
        $MedicalCerti->line2radio = $req->line2radio;
        $MedicalCerti->line2frmdate = $req->line2frmdate;
        $MedicalCerti->line2todate = $req->line2todate;
        $MedicalCerti->line2frmdate2 = $req->line2frmdate2;
        $MedicalCerti->line2todate2 = $req->line2todate2;
        $MedicalCerti->line3radio = $req->line3radio;
        $MedicalCerti->line3select = $req->line3select;
        $MedicalCerti->operatedfor = $req->operatedfor;
        $MedicalCerti->line3date = $req->line3date;
        $MedicalCerti->line4chk = $req->line4chk;
        $MedicalCerti->line4select = $req->line4select;
        $MedicalCerti->line4fromdate = $req->line4fromdate;
        $MedicalCerti->line4todate = $req->line4todate;
        $MedicalCerti->line4chk2 = $req->line4chk2;
        $MedicalCerti->line4select2 = $req->line4select2;
        $MedicalCerti->line4date2 = $req->line4date2;
        $MedicalCerti->line4days = $req->line4days;
        $MedicalCerti->line4chk3 = $req->line4chk3;
        $MedicalCerti->line4select3 = $req->line4select3;
        $MedicalCerti->fitresume = $req->fitresume;
        $MedicalCerti->line4date3 = $req->line4date3;
        $MedicalCerti->identradio = $req->identradio;
        $MedicalCerti->identification = $req->identification;
        $MedicalCerti->consultant = $req->consultant;
        $MedicalCerti->CreatedDate = date('Y-m-d');
        $MedicalCerti->save();
        return $MedicalCerti->id;
    }

    function previewMedicalCertificate($id){
        $result = MedicalCertiModel::find($id);
        $preview = "";
        if($result->line1radio == 1){
            $preview.= "Was under my treatment as an out-patient / in-patient, at this hospital.<br>";
        }
        if($result->line2radio == 1){
            $preview.= "Was treated as an O.P.D. Patient from ".$result->line2frmdate." To ".$result->line2todate.".<br>";
        }
        if($result->line2radio == 2){
            $preview.= "Was admitted as an indoor patient on ".$result->line2frmdate2." And Discharge on ".$result->line2todate2.".<br>";
        }
        if($result->line3radio == 1){
            $preview.= $result->line3select." Was operated for ".$result->operatedfor." on ".$result->line3date.".<br>";
        }
        if($result->line4chk == 1){
            $preview.= $result->line4select." has been advised rest from ".$result->line4fromdate." To ".$result->line4todate.".<br>";
        }
        if($result->line4chk2 == 1){
            $preview.= "However, ".$result->line4select2." is further advised to continue rest ".$result->line4date2." for another ".$result->line4days." days. <br>";
        }
        if($result->line4chk3 == 1){
            $preview.= $result->line4select3." is fit to resume ".$result->fitresume." from ".$result->line4date3.".<br>";
        }
        if($result->identradio == 1){
            $preview.= " Identification Mark : ".$result->identification.".<br>";
        }
        //$preview.= " Consultant  : ".$result->consultant.".<br>";
        // if($result->Details == ''){
        //     $preview = $preview;
        // }
        // else{
        //     $preview = $result->Details;
        // }
        return view('/certificates/preview-medical-certificate',['preview'=>$preview,'id'=>$id]);
    }

    function savePrintMedicalCerti(Request $req){
        $id = $req->saveid;
        $MedicalCerti = MedicalCertiModel::find($id);
        $MedicalCerti->Details = $req->Details;
        $MedicalCerti->save();
        return redirect('/printMedicalCertificate/'.$id);
    }

    function printMedicalCertificate($id){
        $result = MedicalCertiModel::find($id);
        $Details = $result->Details;
        return view('/certificates/print-medical-certificate',['result'=>$result,'Details'=>$Details,'id'=>$id]);
    }
}
