<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\PatientBalanceModel;
use App\Models\ProcedureModel;
use Session;

class PatientBalanceController extends Controller
{
    function patientBalance(){
        $result = PatientBalanceModel::all();
        return view('/patientbalance/view-patient-balance',['data'=>$result]);
    }

    function viewPatientBalance(Request $req){
        if(!empty($req->FromDate))
            {   
                if($req->MrdNo == '' || $req->MrdNo == 0){
                    $result = PatientBalanceModel::where('BalDate',$req->FromDate)->get();
                }
                else{
                    $MrdNo = $req->MrdNo;
                    $result = PatientBalanceModel::where(['MrdNo'=>$MrdNo])->whereBetween('BalDate', array($req->FromDate, $req->ToDate))->get();
                }
            }
            else{
                $result = PatientBalanceModel::all();
            }
            
        return view('/patientbalance/inc-patient-balance-lists',['data'=>$result]);
    }

    function addNewPatientBalance(){
        return view('/patientbalance/add-patient-balance');
    }

    function saveNewPatientBalance(Request $req){
        if($req->action == 'Save'){
            $Appoint = new PatientBalanceModel;
        }
        else{
            $Appoint = PatientBalanceModel::find($req->saveid);
        }
        $Appoint->MrdNo = $req->MrdNo; 
        $Appoint->PatientName = $req->PatientName;
        $Appoint->BalDate = $req->BalDate;
        $Appoint->Amount = $req->Amount;
        $Appoint->Narration = $req->Narration;
        $Appoint->save();
        $AppointId = $Appoint->id;
        return json_encode(array('id'=>$AppointId,'Status'=>1));
    }

    function opdReceipt2($id){
        $procedures = ProcedureModel::where('Type',1)->get();
        $result = PatientBalanceModel::find($id);
        return view('/patientbalance/add-opd-receipt',['data'=>$result,'procedures'=>$procedures]);
    }
}
