<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ProcedureModel;
use Session;
class ProcedureController extends Controller
{
    function procedure(){
        return view('masters/procedure');
    }
    function viewProcedureList(Request $req){
        $result = ProcedureModel::all();
        return view('masters/viewprocedurelist',['data'=>$result]);
    }

    function saveProcedure(Request $req){
        if($req->action == 'Save'){
            $Package = new ProcedureModel;
        }
        else{
            $Package = ProcedureModel::find($req->id);
        }
        $Package->Name = $req->Name; 
        $Package->Amount = $req->Amount;
        $Package->Type = $req->Type;
        $Package->Status = 1;
        $Package->CreatedBy = 19;
        $Package->ModifiedBy = 19;
        $Package->save();
        return 1;
    }

    function editProcedure(Request $req){
        $data = ProcedureModel::find($req->id);
        return json_encode($data);
    }

    function deleteProcedure(Request $req){
        $data=ProcedureModel::find($req->id)->delete();
        return 1;
    }

    function getProcedureDetails(Request $req){
        $data=ProcedureModel::select('Amount')->Where(['Name'=>$req->val,'Type'=>1])->first();
        return $data->Amount;
    }

        function investigationLists(Request $req){
            $result = ProcedureModel::select()->Where(['Type'=>3])->get();
            return view('/masters/inc-investigation-lists',['data'=>$result]);
       }
    
       function getInvestigationAmount(Request $req){
        $ProcId = $req->ProcId;
        $result = DB::select("SELECT SUM(Amount) As Amount,GROUP_CONCAT(Name) AS InvstName FROM tbl_procedures WHERE id IN ($ProcId)");
        return json_encode((array('Amount'=>$result[0]->Amount,'InvstName'=>$result[0]->InvstName)));
       }
}
