<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use App\Http\Controllers\MasterController;
use App\Models\ConsultantModel;
use App\Models\QueueManagement;
use Illuminate\Support\Facades\DB;
use App\Models\OpdReceiptModel;
use App\Models\OpdExpenseModel;
use App\Models\IpdReceiptModel;
use App\Models\IpdMadamReceiptModel;
use App\Models\InvestigationModel2;
use App\Models\OTModel;
use App\Models\OptoModel;
class ReportController extends Controller
{
    function queueReport(){
        $consultantList = (new MasterController)->consultantList();
        $optoList = (new MasterController)->receptionList();
        return view('/opdreport/opdqueuereport',['optoList'=>$optoList,'consultantList'=>$consultantList]);
    }

    function viewDailyQueueReport(Request $req){
            if(!empty($req->FromDate))
            {
                // $result =  DB::table('tbl_queue_managements as tq')
                // ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
                // ->whereBetween('InDate', array($req->FromDate, $req->ToDate))
                //  ->select('tq.*','tu.Name AS Consultant_Name')
                //  ->orderBy('tq.InDate','desc')->get();
                 $sql = "SELECT tq.*,tu4.Username as CreatedByName FROM tbl_queue_managements tq 
                 LEFT JOIN tbl_users tu4 ON tu4.id=tq.CreatedBy
                             WHERE tq.InDate>='$req->FromDate' AND tq.InDate<='$req->ToDate'";   
                 if($req->Consultant!='all'){
                    $sql.= " AND tq.Consultant='$req->Consultant'";
                 }
                 if($req->PayMode!='all'){
                    $sql.= " AND tq.PayMode='$req->PayMode'";
                 }
                 if($req->ConfirmOpto!='all'){
                    $sql.= " AND tq.CreatedBy='$req->ConfirmOpto'";
                 }
                 if($req->PatientType!='all'){
                    $sql.= " AND tq.PatientType='$req->PatientType'";
                 }
                 //return $sql;
                 $result = DB::select($sql);
            }
            //return $result;
            // if($req->Consultant!='all'){
            //     $result =  DB::table('tbl_queue_managements as tq')
            //     ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
            //     ->whereBetween('InDate', array($req->FromDate, $req->ToDate))
            //     ->where('tq.Consultant',$req->Consultant)
            //      ->select('tq.*','tu.Name AS Consultant_Name')
            //      ->orderBy('tq.InDate','desc')->get();
            // }

            $sql2 = "SELECT SUM(Amount) As Amount FROM tbl_queue_managements tq 
                             WHERE tq.InDate>='$req->FromDate' AND tq.InDate<='$req->ToDate'";   
                 if($req->Consultant!='all'){
                    $sql2.= " AND tq.Consultant='$req->Consultant'";
                 }
                 if($req->PayMode!='all'){
                    $sql2.= " AND tq.PayMode='$req->PayMode'";
                 }
                 if($req->ConfirmOpto!='all'){
                    $sql2.= " AND tq.CreatedBy='$req->ConfirmOpto'";
                 }
                 if($req->PatientType!='all'){
                    $sql2.= " AND tq.PatientType='$req->PatientType'";
                 }
                 $result2 = DB::select($sql2);
            $sum = $result2[0]->Amount;
        return view('/opdreport/viewdailyqueuereport',['data'=>$result,'sum'=>$sum]);
    }

    function viewQueueSummaryReport(Request $req){
        if(!empty($req->FromDate))
            {
                // $result =  DB::table('tbl_queue_managements')
                // ->whereBetween('InDate', array($req->FromDate, $req->ToDate))
                // ->groupBy('InDate')
                // ->get();
                $result = DB::select("SELECT SUM(AMOUNT) AS Amount,InDate FROM `tbl_queue_managements` WHERE InDate>='$req->FromDate' AND InDate<='$req->ToDate' GROUP BY InDate");
                $totsum = DB::select("SELECT SUM(AMOUNT) AS TotAmount FROM `tbl_queue_managements` WHERE InDate>='$req->FromDate' AND InDate<='$req->ToDate'");
                $TotAmount = $totsum[0]->TotAmount;

                $fromdate = $req->FromDate;
                $todate = $req->ToDate;
                $total = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->count();
                $male = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Gender'=>'Male'])->count();
                $female = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Gender'=>'Female'])->count();
                $new = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['PatientType'=>'New'])->count();
                $old = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['PatientType'=>'Old'])->count();
                $free = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Amount'=>'0'])->count();
                $paid = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['InDate'=>$fromdate])->where('Amount', '>', '0')->count();
                $appointment = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Appointment'=>'1'])->count();
                $dialted = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Dilated'=>'1'])->count();
                $paid150 = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Amount'=>'150'])->count();
                $paid400 = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Amount'=>'400'])->count();
                $paid600 = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where(['Amount'=>'600'])->count();
            }
            
            return view('/opdreport/view-queue-summary-report',['data'=>$result,'totsum'=>$TotAmount,'total'=>$total,'male'=>$male,'female'=>$female,
            'new'=>$new,'old'=>$old,'free'=>$free,'paid'=>$paid,'appointment'=>$appointment,
            'dialted'=>$dialted,'paid150'=>$paid150,'paid400'=>$paid400,'paid600'=>$paid600]);
    }


    function ipdBillReport(){
        $consultantList = (new MasterController)->consultantList();
        return view('/opdreport/ipd-bill-report',['consultantList'=>$consultantList]);
    }

    function viewIpdTempBillReport(Request $req){
        if(!empty($req->FromDate))
        {
            $result =  DB::table('tbl_temp_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                ->where(['ti.Status'=>'1','ti.Flag'=>0])
                ->select('ti.*','tc.Name As Department')->get();

        }
        if($req->Consultant!='all'){
            $result =  DB::table('tbl_temp_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                ->where('ti.Consultant',$req->Consultant)
                ->where(['ti.Status'=>'1','ti.Flag'=>0])
                ->select('ti.*','tc.Name As Department')->get();
        }
        $sum = $result->sum('PaidAmt');
        return view('/opdreport/view-ipd-temp-bill-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewIpdBillReport(Request $req){
        if(!empty($req->FromDate))
        {
            $result =  DB::table('tbl_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                ->where(['ti.Status'=>'1'])
                ->select('ti.*','tc.Name As Department')->get();

        }
        if($req->Consultant!='all'){
            $result =  DB::table('tbl_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                ->where('ti.Consultant',$req->Consultant)
                ->where(['ti.Status'=>'1'])
                ->select('ti.*','tc.Name As Department')->get();
        }
        $sum = $result->sum('PaidAmt');
        return view('/opdreport/view-ipd-bill-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewExpensesReport(Request $req){
        if(!empty($req->FromDate))
        {
            $result =  OpdExpenseModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->get();  

        }
        //return $result;
        $sum = $result->sum('Amount');
        return view('/opdreport/view-expenses-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewExpensesSummaryReport(Request $req){
        if(!empty($req->FromDate))
        {
            $result = DB::select("SELECT SUM(Amount) AS Amount,CreatedDate FROM tbl_opd_expenses WHERE CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate' GROUP BY CreatedDate");
            $totsum = DB::select("SELECT SUM(Amount) AS TotAmount FROM tbl_opd_expenses WHERE CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'");
            $TotAmount = $totsum[0]->TotAmount;
            //return $TotAmount;
        }
        return view('/opdreport/view-expenses-summary-report',['data'=>$result,'totsum'=>$TotAmount]);
    }

    function allSummaryReport(Request $req){
        if(!empty($req->FromDate))
        {
            // $result = DB::select("SELECT PatientName As Narration,InDate As CreatedDate,Amount,PayMode FROM `tbl_queue_managements` 
            // WHERE InDate>='$req->FromDate' AND InDate<='$req->ToDate' UNION ALL
            // SELECT Narration,CreatedDate,Amount,PayMode FROM `tbl_opd_receipts` 
            // WHERE CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'");
            // $totsum = DB::select("SELECT SUM(AMOUNT) AS TotAmount FROM `tbl_queue_managements` WHERE InDate>='$req->FromDate' AND InDate<='$req->ToDate'");
            // $TotAmount = $totsum[0]->TotAmount;
            // $totsum2 = DB::select("SELECT SUM(Amount) AS TotAmount FROM `tbl_opd_receipts` WHERE CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'");
            // $TotAmount2 = $totsum2[0]->TotAmount;
            // $Balance = $TotAmount - $TotAmount2;
            $fromdate = $req->FromDate;
            $todate = $req->ToDate;
            $opdcash = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where('PayMode','Cash')->sum('Amount');
            $opdmobile = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where('PayMode','Mobile Payment')->sum('Amount');
            $opdcoupon = QueueManagement::whereBetween('InDate', array($fromdate, $todate))->where('PayMode','Coupon')->sum('Amount');
            $opdcashreceipt = OpdReceiptModel::whereBetween('CreatedDate', array($fromdate, $todate))->where(['Paymode'=>'Cash','InvId'=>0])->sum('Amount');
            $opdinvstreceipt = InvestigationModel2::whereBetween('VisitDate', array($fromdate, $todate))->where('InvMoneyReceived','=',1)->sum('Amount');
            //$opdonlinereceipt = InvestigationModel2::whereBetween('VisitDate', array($fromdate, $todate))->where('InvMoneyReceived','=',1)->sum('Amount');
            $opdonlinereceipt = 0;
            $ipdonlinereceipt = IpdReceiptModel::whereBetween('CreatedDate', array($fromdate, $todate))->where('PayMode','Mobile Payment')->sum('Amount');
            $totalcashincome = $opdcash+$opdinvstreceipt;
            $totalonlineincome = $opdmobile+$opdcoupon+$opdonlinereceipt+$ipdonlinereceipt;
            $opdcashexpense = OpdExpenseModel::whereBetween('CreatedDate', array($fromdate, $todate))->where('PayMode','Cash')->sum('Amount');
            $opdonlineexpense = OpdExpenseModel::whereBetween('CreatedDate', array($fromdate, $todate))->where('PayMode','!=','Cash')->sum('Amount');
        }
        
        return view('/opdreport/view-all-summary-report',['opdcashexpense'=>$opdcashexpense,'opdonlineexpense'=>$opdonlineexpense,
        'totalcashincome'=>$totalcashincome,
        'opdcashreceipt'=>$opdcashreceipt,'opdonlinereceipt'=>$opdonlinereceipt,'opdcash'=>$opdcash,
        'opdmobile'=>$opdmobile,'opdcoupon'=>$opdcoupon,'totalonlineincome'=>$totalonlineincome,'ipdonlinereceipt'=>$ipdonlinereceipt,'opdinvstreceipt'=>$opdinvstreceipt]);
    }

    function OpdReport(Request $req){

        if(!empty($req->FromDate))
            {
                if($req->val == 'Cash'){
                    $result =  DB::table('tbl_queue_managements as tq')
                    ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
                    ->whereBetween('InDate', array($req->FromDate, $req->ToDate))
                    ->where('PayMode','Cash')
                    ->select('tq.*','tu.Name AS Consultant_Name')
                    ->orderBy('tq.InDate','desc')->get();
                }
                else{
                    $result =  DB::table('tbl_queue_managements as tq')
                    ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
                    ->whereBetween('InDate', array($req->FromDate, $req->ToDate))
                    ->where('PayMode','!=','Cash')
                    ->select('tq.*','tu.Name AS Consultant_Name')
                    ->orderBy('tq.InDate','desc')->get();
                }
                
            }
           
            $sum = $result->sum('Amount');
        return view('/opdreport/viewdailyqueuereport2',['data'=>$result,'sum'=>$sum]);
    }

    function opdReceiptReport(Request $req){
        if(!empty($req->FromDate))
        {   
            if($req->val == 'Cash'){
            $result =  OpdReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode','Cash')->where(['InvId'=>0])->get();
            }
            else{
                $result =  OpdReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode','!=','Cash')->where(['InvId'=>0])->get();   
            }
        }
       
        $sum = $result->sum('Amount');
        return view('/opdreport/view-opd-receipt-report',['data'=>$result,'sum'=>$sum]);
    }

    function invstReport(Request $req){
        if(!empty($req->FromDate))
        {   
            if($req->val == 'Cash'){
            $result =  InvestigationModel2::whereBetween('VisitDate', array($req->FromDate, $req->ToDate))->where('InvMoneyReceived','=',1)->get();
            }
            else{
                $result =  InvestigationModel2::whereBetween('VisitDate', array($req->FromDate, $req->ToDate))->where('InvMoneyReceived','=',1)->get();   
            }
        }
       
        $sum = $result->sum('Amount');
        return view('/opdreport/view-investigation-report',['data'=>$result,'sum'=>$sum]);
    }


    function opdExpenseReport(Request $req){
        if(!empty($req->FromDate))
        {
            if($req->val == 'Cash'){
            $result =  OpdExpenseModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode','Cash')->get();
            }
            else{
                $result =  OpdExpenseModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode','!=','Cash')->get();   
            }

        }
        $sum = $result->sum('Amount');
        return view('/opdreport/view-opd-expense-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewReceiptReport(Request $req){
        if(!empty($req->FromDate))
        {   
            if($req->PayMode == 'all'){
            $result =  OpdReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->get();
            }
            else{
                $result =  OpdReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode',$req->PayMode)->get();
            }
        }
       
        $sum = $result->sum('Amount');
        return view('/opdreport/view-opd-receipt-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewIpd_ReceiptReport(Request $req){
        if(!empty($req->FromDate))
        {
            if($req->PayMode == 'all'){
                $result =  IpdReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->get();
                }
                else{
            $result =  IpdReceiptModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode',$req->PayMode)->get();
                }
        }
        //return $result;
        $sum = $result->sum('Amount');
        return view('/opdreport/view-ipd-receipt-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewIpd_Madam_ReceiptReport(Request $req){
        if(!empty($req->FromDate))
        {
            if($req->PayMode == 'all'){
                $result =  IpdMadamReceiptModel::whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->get();
                }
                else{
            $result =  IpdMadamReceiptModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where('PayMode',$req->PayMode)->get();
                }

           

        }
        //return $result;
        $sum = $result->sum('Amount');
        return view('/opdreport/view-ipd-madam-receipt-report',['data'=>$result,'sum'=>$sum]);
    }

    function viewIpdReport(Request $req){
        if(!empty($req->FromDate))
        {
            if($req->PayMode=='1'){
            $result = OTModel::whereBetween('SurgeryDate', array($req->FromDate, $req->ToDate))->where(['ConfirmSurgery'=>'Yes'])->get();
            return view('/opdreport/view-ot-list',['data'=>$result,'fromdate'=>$req->FromDate]);
            }
            else{
                $result = OTModel::whereBetween('CounsellingDate', array($req->FromDate, $req->ToDate))->get();
                return view('/opdreport/view-counselling-list',['data'=>$result,'fromdate'=>$req->FromDate]);
            }
        }
        
    }

    function viewOpdCounsellingReport(Request $req){
        if(!empty($req->FromDate))
        {
            
            $result = ConsultantModel::select('id', 'CouncRemark', 'MrdNo', 'VisitDate', 'PatientName')
            ->whereBetween('VisitDate', array($req->FromDate, $req->ToDate))
            ->where('CouncRemark', '!=', '')
            ->get();
                return view('/opdreport/view-opd-counselling-list',['data'=>$result]);
            
        }
        
    }
    
    
    function viewReferredByReport(Request $req){
        if(!empty($req->FromDate))
        {
            $result = OptoModel::select('MrdNo', 'VisitNo', 'VisitDate', 'PatientName', 'Age', 'Gender', 'RefBy')
            ->whereBetween('VisitDate', array($req->FromDate, $req->ToDate))
            ->where('RefBy', '!=', '')
            ->get();
                return view('/opdreport/view-opd-referredby-list',['data'=>$result]);
            
        }
    }

}