<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\VaccineReceiptModel;
use App\Models\UserMaster;
use Session;

class VaccineReceiptController extends Controller
{
    function VaccineReceipt(){
        $today = $this->todayVaccineReceipt();
        $total = $this->totalVaccineReceipt();
        $consultants = UserMaster::where('Type', 'Consultant')->get();
        
        return view('vaccine-receipt/view-vaccine-receipt', [
            'today' => $today,
            'total' => $total,
            'consultants' => $consultants
        ]);
    }

    function viewVaccineReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        
        if(!empty($req->FromDate)) {
            $sql = "SELECT tvr.*, tp.Phone FROM tbl_vaccine_receipts tvr 
                    LEFT JOIN tbl_patients tp ON tp.UhidNo = tvr.UhidNo 
                    WHERE tvr.Status = 1 AND tvr.Date >= '$req->FromDate' AND tvr.Date <= '$req->ToDate'";
            
            if($SrchPayMode != '') {
                $sql .= " AND tvr.PayMode = '$SrchPayMode'";
            }
            $sql .= " ORDER BY tvr.id DESC";
            $result = DB::select($sql);

            $sql2 = "SELECT SUM(Amount) AS Amount FROM tbl_vaccine_receipts 
                     WHERE Status = 1 AND Date >= '$req->FromDate' AND Date <= '$req->ToDate'";
            if($SrchPayMode != '') {
                $sql2 .= " AND PayMode = '$SrchPayMode'";
            }
            $result2 = DB::select($sql2);
            $total = $result2[0]->Amount ? $result2[0]->Amount : 0;
        } else {
            $result = VaccineReceiptModel::where('Date', $CurrDate)->orderBy('id', 'desc')->get();
            $total = $result->sum('Amount');
        }

        return view('vaccine-receipt/inc-vaccine-receipt-list', ['data' => $result, 'total' => $total]);
    }

    function fetchVaccineReceiptRecord(Request $req){
        $result = VaccineReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteVaccineReceipt(Request $req){
        VaccineReceiptModel::where(['id' => $req->id])->update(['Status' => 0]);
        $today = $this->todayVaccineReceipt();
        $total = $this->totalVaccineReceipt();
        echo json_encode(array('status' => '1', 'today' => $today, 'total' => $total)); 
    }

    function saveVaccineReceipt(Request $req){
        $CurrDate = date('Y-m-d');
        
        if($req->action == 'Save') {
            $VaccineReceipt = new VaccineReceiptModel;
            $VaccineReceipt->CreatedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $VaccineReceipt->CreatedDate = $CurrDate;
            $VaccineReceipt->ReceiptNo = $this->getVaccineReceiptNo();
        } else {
            $VaccineReceipt = VaccineReceiptModel::find($req->id);
            $VaccineReceipt->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $VaccineReceipt->ModifiedDate = $CurrDate;
        }

        $VaccineReceipt->Date = $req->Date ? $req->Date : $CurrDate;
        $VaccineReceipt->UhidNo = $req->UhidNo ? $req->UhidNo : null;
        $VaccineReceipt->PatientName = $req->PatientName ? $req->PatientName : null;
        $VaccineReceipt->Procedure = 'VACCINE'; // Fixed to VACCINE
        $VaccineReceipt->ConsultantId = $req->ConsultantId ? $req->ConsultantId : null;
        $VaccineReceipt->Consultant = $req->Consultant ? $req->Consultant : null;
        $VaccineReceipt->Amount = $req->Amount ? $req->Amount : 0;
        $VaccineReceipt->PayMode = $req->PayMode ? $req->PayMode : 'Cash';
        $VaccineReceipt->ChequeNo = ($req->ChequeNo && trim($req->ChequeNo) != '') ? $req->ChequeNo : null;
        $VaccineReceipt->ChequeDate = ($req->ChequeDate && trim($req->ChequeDate) != '') ? $req->ChequeDate : null;
        $VaccineReceipt->Status = 1;
        
        $VaccineReceipt->save();
        $postid = $VaccineReceipt->id;
        $today = $this->todayVaccineReceipt();
        $total = $this->totalVaccineReceipt();
        
        return json_encode(array('status' => 1, 'today' => $today, 'total' => $total, 'id' => $postid));
    }

    function todayVaccineReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt = VaccineReceiptModel::where(['Date' => $CurrDate, 'Status' => 1])->count();
        return $rncnt;
    }

    function totalVaccineReceipt(){
        $rncnt = VaccineReceiptModel::where('Status', 1)->count();
        return $rncnt;
    }

    function getVaccineReceiptNo(){
        $maxReceiptNo = VaccineReceiptModel::max('ReceiptNo');
        $receiptNo = ($maxReceiptNo) ? $maxReceiptNo + 1 : 1;
        return $receiptNo;
    }

    function getVaccineReceiptNoAjax(Request $req){
        $receiptNo = $this->getVaccineReceiptNo();
        return response()->json(['receipt_no' => $receiptNo]);
    }

    function vaccineReceiptPrint($id){
        $result = VaccineReceiptModel::where('id', $id)->first();
        return view('vaccine-receipt/vaccine-receipt-print', ['result' => $result]);
    }
}
