<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\XrayReceiptModel;
use App\Models\UserMaster;
use Session;

class XrayReceiptController extends Controller
{
    function XrayReceipt(){
        $today = $this->todayXrayReceipt();
        $total = $this->totalXrayReceipt();
        $consultants = UserMaster::where('Type', 'Consultant')->get();
        
        return view('xray-receipt/view-xray-receipt', [
            'today' => $today,
            'total' => $total,
            'consultants' => $consultants
        ]);
    }

    function viewXrayReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        
        if(!empty($req->FromDate)) {
            $sql = "SELECT txr.*, tp.Phone FROM tbl_xray_receipts txr 
                    LEFT JOIN tbl_patients tp ON tp.MrdNo = txr.MrdNo 
                    WHERE txr.Status = 1 AND txr.Date >= '$req->FromDate' AND txr.Date <= '$req->ToDate'";
            
            if($SrchPayMode != '') {
                $sql .= " AND txr.PayMode = '$SrchPayMode'";
            }
            $sql .= " ORDER BY txr.id DESC";
            $result = DB::select($sql);

            $sql2 = "SELECT SUM(Amount) AS Amount FROM tbl_xray_receipts 
                     WHERE Status = 1 AND Date >= '$req->FromDate' AND Date <= '$req->ToDate'";
            if($SrchPayMode != '') {
                $sql2 .= " AND PayMode = '$SrchPayMode'";
            }
            $result2 = DB::select($sql2);
            $total = $result2[0]->Amount ? $result2[0]->Amount : 0;
        } else {
            $result = XrayReceiptModel::where('Date', $CurrDate)->orderBy('id', 'desc')->get();
            $total = $result->sum('Amount');
        }

        return view('xray-receipt/inc-xray-receipt-list', ['data' => $result, 'total' => $total]);
    }

    function fetchXrayReceiptRecord(Request $req){
        $result = XrayReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteXrayReceipt(Request $req){
        XrayReceiptModel::where(['id' => $req->id])->update(['Status' => 0]);
        $today = $this->todayXrayReceipt();
        $total = $this->totalXrayReceipt();
        echo json_encode(array('status' => '1', 'today' => $today, 'total' => $total)); 
    }

    function saveXrayReceipt(Request $req){
        $CurrDate = date('Y-m-d');
        
        if($req->action == 'Save') {
            $XrayReceipt = new XrayReceiptModel;
            $XrayReceipt->CreatedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $XrayReceipt->CreatedDate = $CurrDate;
            $XrayReceipt->ReceiptNo = $this->getXrayReceiptNo();
        } else {
            $XrayReceipt = XrayReceiptModel::find($req->id);
            $XrayReceipt->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $XrayReceipt->ModifiedDate = $CurrDate;
        }

        $XrayReceipt->Date = $req->Date ? $req->Date : $CurrDate;
        $XrayReceipt->MrdNo = $req->MrdNo ? $req->MrdNo : null;
        $XrayReceipt->IpdNo = $req->IpdNo ? $req->IpdNo : null;
        $XrayReceipt->UhidNo = $req->UhidNo ? $req->UhidNo : null;
        $XrayReceipt->PatientName = $req->PatientName ? $req->PatientName : null;
        $XrayReceipt->Procedure = 'X-RAY'; // Fixed to X-RAY
        $XrayReceipt->TotalNo = $req->TotalNo ? $req->TotalNo : null;
        $XrayReceipt->ConsultantId = $req->ConsultantId ? $req->ConsultantId : null;
        $XrayReceipt->Consultant = $req->Consultant ? $req->Consultant : null;
        $XrayReceipt->Amount = $req->Amount ? $req->Amount : 0;
        $XrayReceipt->PayMode = $req->PayMode ? $req->PayMode : 'Cash';
        $XrayReceipt->Status = 1;
        
        $XrayReceipt->save();
        $postid = $XrayReceipt->id;
        $today = $this->todayXrayReceipt();
        $total = $this->totalXrayReceipt();
        
        return json_encode(array('status' => 1, 'today' => $today, 'total' => $total, 'id' => $postid));
    }

    function todayXrayReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt = XrayReceiptModel::where(['Date' => $CurrDate, 'Status' => 1])->count();
        return $rncnt;
    }

    function totalXrayReceipt(){
        $rncnt = XrayReceiptModel::where('Status', 1)->count();
        return $rncnt;
    }

    function getXrayReceiptNo(){
        $maxReceiptNo = XrayReceiptModel::max('ReceiptNo');
        $receiptNo = ($maxReceiptNo) ? $maxReceiptNo + 1 : 1;
        return $receiptNo;
    }

    function getXrayReceiptNoAjax(Request $req){
        $receiptNo = $this->getXrayReceiptNo();
        return response()->json(['receipt_no' => $receiptNo]);
    }

    function xrayReceiptPrint($id){
        $result = XrayReceiptModel::where('id', $id)->first();
        return view('xray-receipt/xray-receipt-print', ['result' => $result]);
    }
}
