@include('header')
<style type="text/css">
fieldset legend {
    background: inherit;
    font-family: "Lato", sans-serif;
    color: #650812;
    font-size: 15px;
    left: 10px;
    padding: 0 10px;
    position: absolute;
    top: -12px;
    font-weight: 400;
    width: auto !important;
    border: none !important;
}

fieldset {
    background: #ffffff;
    border: 1px solid #C43853;
    border-radius: 5px;
    margin: 15px 0 1px 0;
    padding: 10px;
    position: relative;
}

.form-control {
    min-height: 1px;
    height: 25px;
}

.table th,
.table td {
    padding: 0.325rem;
}
</style>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Medical Certificate</h4>

    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        <input type="hidden" name="actionvalue" id="actionvalue" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        @csrf
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">

                        <fieldset>
                            <legend>Patient Details</legend>
                            <div class="row">
                                

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">MRD No <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder=""
                                            value="" oninput="getPatientVal()">
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Patient Name <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="PatientName" id="PatientName"
                                            placeholder="" required value="">
                                    </div>
                                </div>

                                <div class="col-sm-1">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Age <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="Age" id="Age" placeholder=""
                                            required value="">
                                    </div>
                                </div>


                                <div class="col-sm-5">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Diagnosis <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" list="DataList2" name="Diagnosis"
                                            id="Diagnosis" placeholder="" value="">
                                        <datalist id="DataList2">
                                            @foreach($diagnosisList as $result)
                                            <option value="{{$result->Description}}">
                                                @endforeach
                                        </datalist>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="radio" value="1" name="line1radio">
                                            <span class="form-check-label">Was under my treatment as an out-patient /
                                                in-patient, at this hospital.</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="radio" value="1" name="line2radio">
                                            <span class="form-check-label">Was treated as an O.P.D. Patient from
                                                <input type="date" name="line2frmdate" value="{{date('Y-m-d')}}">
                                                To
                                                <input type="date" name="line2todate" value="{{date('Y-m-d')}}">
                                            </span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="radio" value="2" name="line2radio">
                                            <span class="form-check-label">Was admitted as an indoor patient on
                                                <input type="date" name="line2frmdate2" value="{{date('Y-m-d')}}">
                                                And Discharge on
                                                <input type="date" name="line2todate2" value="{{date('Y-m-d')}}">
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <div class="row">

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="radio" value="1" name="line3radio">
                                            <span class="form-check-label">
                                                <select name="line3select">
                                                    <option value="">...</option>
                                                    <option value="He">He</option>
                                                    <option value="She">She</option>
                                                </select>
                                                Was operated for
                                                <input type="text" list="DataList3" name="operatedfor" id="operatedfor"
                                                    placeholder="" value="" style="width: 300px;">
                                                <datalist id="DataList3">

                                                    <option value="">

                                                </datalist>
                                                on
                                                <input type="date" name="line3date" value="{{date('Y-m-d')}}">
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <div class="row">

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="checkbox" value="1" name="line4chk">
                                            <span class="form-check-label">
                                                <select name="line4select">
                                                    <option value="">...</option>
                                                    <option value="He">He</option>
                                                    <option value="She">She</option>
                                                </select>
                                                has been advised rest from
                                                <input type="date" name="line4fromdate" value="{{date('Y-m-d')}}">
                                                To
                                                <input type="date" name="line4todate" value="{{date('Y-m-d')}}">
                                            </span>
                                        </label>
                                    </div>
                                </div>


                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="checkbox" value="1" name="line4chk2">
                                            However,
                                            <span class="form-check-label">
                                                <select name="line4select2">
                                                    <option value="">...</option>
                                                    <option value="He">He</option>
                                                    <option value="She">She</option>
                                                </select>
                                                is further advised to continue rest
                                                <input type="date" name="line4date2" value="{{date('Y-m-d')}}">
                                                for another
                                                <input type="text" style="width: 50px;" name="line4days"> days.
                                            </span>
                                        </label>
                                    </div>
                                </div>


                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="checkbox" value="1" name="line4chk3">

                                            <span class="form-check-label">
                                                <select name="line4select3">
                                                    <option value="">...</option>
                                                    <option value="He">He</option>
                                                    <option value="She">She</option>
                                                </select>
                                                is fit to resume
                                                <input type="text" list="DataList4" name="fitresume" id="fitresume"
                                                    placeholder="" value="" style="width: 300px;">
                                                <datalist id="DataList4">

                                                    <option value="">

                                                </datalist>
                                                from
                                                <input type="date" name="line4date3" value="{{date('Y-m-d')}}">
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <div class="row">

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">
                                            <input class="form-check-input" type="radio" value="1"
                                                name="identradio">
                                            <span class="form-check-label">

                                                Identification Mark
                                                <input type="text" name="identification" id="identification"
                                                    placeholder="" value="" style="width: 500px;">


                                            </span>
                                        </label>
                                    </div>
                                </div>


                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-check">

                                            <span class="form-check-label">

                                                Select Consultant
                                                <input type="text" name="consultant" list="DataList5" id="consultant"
                                                    placeholder="" value="" style="width: 300px;">
                                                <datalist id="DataList5">

                                                    @foreach($consultantList as $result)
                                                    <option value="{{$result->Name}}">
                                                        @endforeach

                                                </datalist>


                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                <button type="submit" name="submit" class="btn btn-primary btn-finish"
                    id="submit">Preview</button>
                    </div>
                                </div>
                            </div>
                        </fieldset>




                    </div>
                </div>
            </div>

        </div>
    </form>





</div>

@include('footerscript')
<script type="text/javascript">
function getPatientVal() {
    var MrdNo = $('#MrdNo').val();
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: MrdNo
        },
        dataType: "json",
        success: function(data) {
            console.log(data);
            //$('#MrdNo').val(data.MrdNo);
            if(data == null){
                $('#PatientName').val('');
            $('#Age').val('');
            }
            else{
                $('#PatientName').val(data.PatientName);
            $('#Age').val(data.Age);
            }
            
        }
    });
}

$(document).ready(function() {
    $(document).on("change", "#PatientId", function(event) {
        var val = this.value;
        getPatientVal(val);

    });

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveMedicalCertificate') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    console.log(data);
                    $('#saveid').val(data);
                    $('#actionvalue').val('Edit');
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Preview');
                    setTimeout(function() {
            window.open(
                '/{{projectUrl()}}previewMedicalCertificate/' + data, 'popUpWindow3',
                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
                }
            });
        }
    });


});
</script>
