<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 20px 0 1px 0;
        padding: 25px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
    }

    .col-sm-12,
    .col-sm,
    .col-sm-auto,
    .col-md-1,
    .col-md-2,
    .col-md-3,
    .col-md-4,
    .col-md-5,
    .col-md-6,
    .col-md-7,
    .col-md-8,
    .col-md-9,
    .col-md-10,
    .col-md-11,
    .col-md-12,
    .col-md,
    .col-md-auto,
    .col-lg-1,
    .col-lg-2,
    .col-lg-3,
    .col-lg-4,
    .col-lg-5,
    .col-lg-6,
    .col-lg-7,
    .col-lg-8,
    .col-lg-9,
    .col-lg-10,
    .col-lg-11,
    .col-lg-12,
    .col-lg,
    .col-lg-auto,
    .col-xl-1,
    .col-xl-2,
    .col-xl-3,
    .col-xl-4,
    .col-xl-5,
    .col-xl-6,
    .col-xl-7,
    .col-xl-8,
    .col-xl-9,
    .col-xl-10,
    .col-xl-11,
    .col-xl-12,
    .col-xl,
    .col-xl-auto {
        position: relative;
        width: 100%;
        padding-right: 1px;
        padding-left: 6px;
    }
    </style>
</head>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold mb-0">O.T. Notes</h4>
    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        <input type="hidden" name="action" id="actionvalue" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        @csrf


        <div class="row">
            <div class="col-md-12 mb-1">


                <div class="card mb-2">


                    <div class="table-responsive" style="overflow-x:auto;">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>


                                <tr>
                                <th width="10" align="center" valign="top">O.T. Date </th>
                                    <th width="50" align="center" valign="top"><input type="date" class="form-control"
                                            placeholder="" id="CreatedDate" name="CreatedDate" readonly value="">
                                        <div class="clearfix"></div>
                                    </th>

                                    <th width="10" align="center" valign="top">Mrd.No </th>
                                    <th width="50" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="MrdNo" name="MrdNo" readonly value="{{$MrdNo}}">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Patient Name </th>
                                    <th width="180" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" name="PatientName" id="PatientName" value="" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Age </th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Age" name="Age" value="" readonly>
                                    <th width="30" align="center" valign="top">Mobile</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Phone" name="Phone" value="" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Address</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Address" name="Address" value="" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                    <input type="hidden" name="Gender" id="Gender" value="">
                                    <input type="hidden" name="Eye" id="Eye" value="">
                                </tr>

                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>


                </div>


            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <fieldset>
                            <legend>Diagnosis</legend>
                            <div class="row">
                                <div class="col-lg-10">
                                    <div class="form-group">
                                        <textarea class="form-control" placeholder="Search for..." name="Diagnosis"
                                            id="Diagnosis"></textarea>

                                    </div>
                                </div>
                                <div class="col-lg-2">
                                    <span class="input-group-append">
                                        <button class="btn btn-secondary" type="button" data-toggle="modal"
                                            data-target="#modal-report" id="add_button"
                                            onclick="getValue('Diagnosis','Diagnosis')">...</button>
                                    </span>
                                </div>
                            </div>

                        </fieldset>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Investigation</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="50" align="center" valign="top">B.S</th>

                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="Bs" id="Bs" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">B.P</th>

                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="Bp" id="Bp" class="form-control" placeholder=""
                                                        value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">IOP </th>
                                                <th width="100" align="center" valign="top">
                                                    <input type="text" name="IopRe" id="IopRe" class="form-control"
                                                        placeholder="" value="">
                                                </th>
                                                <th width="105" align="center" valign="top"><input type="text"
                                                        name="IopLe" id="IopLe" class="form-control" placeholder=""
                                                        value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">Other </th>
                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="Other" id="Other" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>

                                            </tr>
                                            <th width="50" align="center" valign="top" colspan="2">Category </th>
                                            <th width="50" align="left" valign="top" colspan="2">
                                                <select class="form-control" name="Category" id="Category"
                                                    style="height: 31px">
                                                    <option selected="" value="">...
                                                    </option>
                                                    <option value="Routine">Routine
                                                    </option>
                                                    <option value="Cashless">Cashless
                                                    </option>

                                                </select>
                                            </th>
                                            <tr>

                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>


                            </fieldset>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Biometry</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="10" align="center" valign="top">K1</th>

                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="K1Re" id="K1Re" class="form-control" placeholder=""
                                                        value=""></th>

                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="K1Le" id="K1Le" class="form-control" placeholder=""
                                                        value=""></th>

                                            </tr>
                                            <tr>

                                                <th width="10" align="center" valign="top">K2

                                                    </td>
                                                </th>
                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="K2Re" id="K2Re" class="form-control" placeholder=""
                                                        value=""></th>

                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="K2Le" id="K2Le" class="form-control" placeholder=""
                                                        value=""></th>

                                            </tr>
                                            <tr>


                                                <th width="10" align="center" valign="top">A.L

                                                    </td>
                                                </th>
                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="AL" id="AL" class="form-control" placeholder=""
                                                        value=""></th>

                                            </tr>
                                            <tr>


                                                <th width="10" align="center" valign="top">ACD

                                                    </td>
                                                </th>
                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="Acd" id="Acd" class="form-control" placeholder=""
                                                        value=""></th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>IOL Details</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="5" align="center" valign="top">IOL Name</th>

                                                <th width="50" align="center" valign="top"><select class="form-control" name="IolName" id="IolName"
                                                                    style="height: 33px;" onchange="modelLists(this.value,'')">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                    
                                                                </select>
                                                </th>

                                        </thead>
                                        <thead>

                                            <tr>
                                                <th width="5" align="center" valign="top">IOL Type</th>

                                                <th width="50" align="center" valign="top"><select class="form-control" name="IolType" id="IolType"
                                                                    style="height: 33px;" onchange="powerLists(this.value,'')">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                   
                                                                </select>
                                                </th>

                                        </thead>
                                        <thead>

                                            <tr>
                                                <th width="5" align="center" valign="top">IOL Power</th>

                                                <th width="50" align="center" valign="top"><select class="form-control" name="IolPower" id="IolPower"
                                                                    style="height: 33px;">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                   
                                                                </select>
                                                </th>

                                        </thead>
                                        <thead>
                                            <tr>
                                                <th width="5" align="center" valign="top">Formula</th>

                                                <th width="40" align="center" valign="top"><input type="text"
                                                        name="Formula" id="Formula" class="form-control" placeholder=""
                                                        value=""></th>
                                            </tr>
                                        </thead>
                                        <thead>

                                            <tr>
                                                <th width="5" align="center" valign="top">A-Constant</th>

                                                <th width="50" align="center" valign="top" colspan="2"><input
                                                        type="text" name="Aconstant" id="Aconstant" class="form-control"
                                                        placeholder="" value=""></th>

                                            </tr>

                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <fieldset>
                            <!-- <legend>Pre-OP Notes</legend> -->
                            <div class="row">
                                <table class="table table-bordered table-striped mb-0">
                                    <thead>

                                        <tr>
                                            <th width="10" align="center" valign="top">Opr. Surgeon</th>

                                            <th width="120" align="center" valign="top" colspan="2"><input type="text"
                                                    name="Surgeon" id="Surgeon" class="form-control"
                                                    placeholder="" value="">
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                            <th width="10" align="center" valign="top"><span class="input-group-append">
                                                    <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                        data-target="#modal-report" id="add_button"
                                                        onclick="getValue('Surgeon','Surgeon')">...</button>
                                                </span> </th>

                                            <th width="60" align="center" valign="top">Assistant
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                            <th width="120" align="center" valign="top"><input type="text"
                                                    name="Assistant" id="Assistant" class="form-control"
                                                    placeholder="" value=""></th>
                                            <th width="10" align="center" valign="top"><span class="input-group-append">
                                                    <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                        data-target="#modal-report" id="add_button"
                                                        onclick="getValue('Assistant','Assistant')">...</button>
                                                </span>
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th width="40" align="center" valign="top">Anaethetist</th>
                                            <th width="120" align="center" valign="top"><input type="text"
                                                    name="Anaethetist" id="Anaethetist" class="form-control"
                                                    placeholder="" value="">
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                            <th width="10" align="center" valign="top"><span class="input-group-append">
                                                    <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                        data-target="#modal-report" id="add_button"
                                                        onclick="getValue('Anaesthetist','Anaethetist')">...</button>
                                                </span></th>

                                            <th width="129" align="center" valign="top">Packages
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                            <th width="129" align="center" valign="top"><input class="form-control"
                                                    type="text" name="Package" id="Package" value="">

                                            </th>
                                        </tr>
                                        <tr>
                                            <th width="129" align="center" valign="top">Surgery Performed
                                                <div class="clearfix"></div>
                                                </td>
                                            </th>
                                            <th colspan="5">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="SurgeryPerformed" id="SurgeryPerformed"></textarea>

                                            </th>
                                            <th>
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('sugestedsurgery','SurgeryPerformed')">...</button>
                                            </th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>


                        </fieldset>
                    </div>

                    <div class="col-md-12">
                        <fieldset>
                            <legend>Surgery Details</legend>
                            <div class="row">
                                <table class="table table-bordered table-striped mb-0">

                                    <thead>

                                        <tr>
                                            <th width="5" align="center" valign="top">Dilated By</th>

                                            <th width="50" align="center" valign="top"><input type="text"
                                                    name="DilatedBy" id="DilatedBy" class="form-control"
                                                    placeholder="" value=""></th>
                                            <th width="5" align="center" valign="top">Anesthesia Type


                                            </th>
                                            <th width="80" align="center" valign="top"><input type="text"
                                                    name="AnesthesiaType" id="AnesthesiaType" class="form-control"
                                                    placeholder="" value=""></th>

                                            <th width="5" align="center" valign="top">Draping</th>

                                            <th width="40" align="center" valign="top"><input type="text"
                                                    name="Draping" id="Draping" class="form-control"
                                                    placeholder="" value=""></th>
                                            <th width="5" align="center" valign="top">Speculum</th>

                                            <th width="40" align="center" valign="top"><input type="text"
                                                    name="Speculum" id="Speculum" class="form-control"
                                                    placeholder="" value=""></th>
                                            <th width="5" align="center" valign="top">Conjunctival Wash</th>

                                            <th width="50" align="center" valign="top" colspan="2"><input type="text"
                                                    name="ConjunctivalWash" id="ConjunctivalWash"
                                                    class="form-control" placeholder="" value=""></th>





                                        </tr>

                                        <tr>
                                            <th width="10" align="center" valign="top">Sideport Incision</th>
                                            <th width="50" align="center" valign="top"><input class="form-control"
                                                    type="text" list="cmb_sideport" name="SideportIncision" id="SideportIncision"
                                                    value="">
                                                <datalist id="cmb_sideport">

                                                    <option value="Yes">
                                                    <option value="No">

                                                </datalist>
                                            </th>
                                            <th width="10" align="center" valign="top">Viscoelastic</th>
                                            <th width="50" align="center" valign="top"><input class="form-control"
                                                    type="text" list="cmb_viscoelastic" name="Viscoelastic"
                                                    id="Viscoelastic" value="">
                                                <datalist id="cmb_viscoelastic">

                                                    <option value="Yes">
                                                    <option value="No">

                                                </datalist>
                                            </th>
                                            <th width="10" align="center" valign="top">CCC</th>
                                            <th width="50" align="center" valign="top"><input class="form-control"
                                                    type="text" list="ccc" name="ccc" id="ccc" value="">
                                                <datalist id="ccc">

                                                    <option value="Yes">
                                                    <option value="No">

                                                </datalist>
                                            </th>
                                            <th width="10" align="center" valign="top">Cap Staining</th>
                                            <th width="130" align="center" valign="top">
                                                <div class="input-group">
                                                    <input type="text" name="CapStaining" id="CapStaining"
                                                        class="form-control" placeholder="" value="">
                                                    <span class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Capstaining','CapStaining')"
                                                            style="height: 26px;line-height: 0.47;">...</button>
                                                    </span>
                                                </div>
                                            </th>

                                            <th width="10" align="left" valign="top">Irrigation Solution </th>
                                            <th width="130" align="center" valign="top">
                                                <div class="input-group">
                                                    <input type="text" name="IrrigationSol" id="IrrigationSol"
                                                        class="form-control" placeholder="" value="">
                                                    <span class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Irrigatingsol','IrrigationSol')"
                                                            style="height: 26px;line-height: 0.47;">...</button>
                                                    </span>
                                                </div>
                                            </th>
                                            </th>



                                        </tr>
                                        <tr>
                                            <th width="10" align="center" valign="top">Hydroscetion</th>
                                            <th width="20" align="center" valign="top">
                                                <div class="input-group">
                                                    <input type="text" name="Hydroscetion" id="Hydroscetion"
                                                        class="form-control" placeholder="" value="">
                                                    <span class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Hydroscetion','Hydroscetion')"
                                                            style="height: 26px;line-height: 0.47;">...</button>
                                                    </span>
                                                </div>
                                            </th>
                                            <th width="10" align="center" valign="top">Nucleus Removal</th>
                                            <th width="130" align="center" valign="top">
                                                <div class="input-group">
                                                    <input type="text" name="Nucleus" id="Nucleus"
                                                        class="form-control" placeholder="" value="">
                                                    <span class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button" onclick="getValue('Nucleus','Nucleus')"
                                                            style="height: 26px;line-height: 0.47;">...</button>
                                                    </span>
                                                </div>
                                            </th>
                                            <th width="10" align="center" valign="top">Cortical Wash</th>
                                            <th width="20" align="center" valign="top"><input class="form-control"
                                                    type="text" list="cmb_cortical" name="CorticalWash" id="CorticalWash"
                                                    value="">
                                                <datalist id="cmb_cortical">

                                                    <option value="YES">
                                                    <option value="No">
                                                </datalist>
                                            </th>
                                            <th width="10" align="center" valign="top">LRI</th>
                                            <th width="130" align="center" valign="top"><input class="form-control"
                                                    type="text" list="lri" name="Lri" id="Lri" value="">
                                                <datalist id="lri">

                                                    <option value="YES">
                                                    <option value="No">
                                                </datalist>
                                            </th>
                                            <th width="10" align="center" valign="top">Wound Hydration</th>
                                            <th width="130" align="center" valign="top"><input class="form-control"
                                                    type="text" list="wh" name="WoundHydration"
                                                    id="WoundHydration" value="">
                                                <datalist id="wh">

                                                    <option value="YES">
                                                    <option value="No">
                                                </datalist>
                                            </th>
                                        </tr>
                                        <tr>

                                            <th width="10" align="center" valign="top">Intracameral </th>
                                            <th width="130" align="center" valign="top"><input class="form-control"
                                                    type="text" list="cmb_intracameral" name="Intracameral"
                                                    id="Intracameral" value="">
                                                <datalist id="cmb_intracameral">

                                                    <option value="YES">
                                                    <option value="No">
                                                </datalist>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>


                        </fieldset>

                    </div>
                    <div>
                        <div>


                        </div>

                    </div>
                </div>
            </div>
            <div class="form-group col-md-12" style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">
                <fieldset>
                    <legend>Cashless Package</legend>
                    <div class="table-responsive" style="overflow-x:auto;">
                        <table id="report-table" class="table table-bordered table-striped mb-0">
                            <thead>
                                <tr>


                                    <td width="10" align="left" valign="top">Package Amount
                                    </td>
                                    <td width="100" align="left" valign="top"><input name="PkgAmt" type="text"
                                            class="form-control" id="PkgAmt" value="" placeholder="">
                                    </td>

                                    <td width="10" align="left" valign="top">Insurane Company
                                    </td>
                                    <td width="200" align="left" valign="top"><input name="InsComp" type="text"
                                            class="form-control" id="InsComp" value="" placeholder="">
                                    </td>

                                    <td width="10" align="left" valign="top">Request Amount
                                    </td>
                                    <td width="100" align="left" valign="top"><input name="ReqAmt" type="text"
                                            class="form-control" id="ReqAmt" value="" placeholder="">
                                    </td>
                                    <td width="10" align="left" valign="top">Sanctioned Amount
                                    </td>
                                    <td width="100" align="left" valign="top"><input name="SanctAmt" type="text"
                                            class="form-control" id="SanctAmt" value="" placeholder="">
                                    </td>

                                </tr>
                                <tr>
                                    <td width="10" align="left" valign="top">Additional Amt Paid
                                        from Patient
                                    </td>
                                    <td width="100" align="left" valign="top"><input name="AddAmt" type="text"
                                            class="form-control" id="AddAmt" value="" placeholder="">
                                    </td>

                                    <td width="10" align="left" valign="top">Settle Amount </td>
                                    <td width="200" align="left" valign="top"><input name="SettleAmt" type="text"
                                            class="form-control" id="SettleAmt" value="" placeholder="">
                                    </td>

                                    <td width="10" align="left" valign="top">Settle Date </td>
                                    <td width="100" align="left" valign="top"><input type="date" class="form-control"
                                            name="SettleDate" id="SettleDate" value="{{date('Y-m-d')}}"></td>
                                    <td width="10" align="left" valign="top">UTR No </td>
                                    <td width="100" align="left" valign="top"><input name="UtrNo" type="text"
                                            class="form-control" id="UtrNo" value="" placeholder="">
                                    </td>
                                </tr>
                            </thead>

                        </table>

                    </div>

                </fieldset>

            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <fieldset>
                    <legend>Add. Procedure & Comments</legend>
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="form-group">
                                <textarea class="form-control" placeholder="Search for..." name="ProcedureComments"
                                    id="ProcedureComments"></textarea>

                            </div>
                        </div>
                        <div class="col-lg-2">
                            <span class="input-group-append">
                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                    data-target="#modal-report" id="add_button"
                                    onclick="getValue('Procedures','ProcedureComments')">...</button>
                            </span>
                        </div>
                    </div>


                </fieldset>
            </div>

            <div class="col-md-4">
                <fieldset>
                    <legend>Remarks</legend>
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="form-group">
                                <textarea class="form-control" placeholder="Search for..." name="Remarks"
                                    id="Remarks"></textarea>

                            </div>
                        </div>
                        <div class="col-lg-2">
                            <span class="input-group-append">
                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                    data-target="#modal-report" id="add_button"
                                    onclick="getValue('Remark','Remarks')">...</button>
                            </span>
                        </div>
                    </div>


                </fieldset>
            </div>

            <div class="col-md-4">
                <fieldset>
                    <legend></legend>
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" name="StudyPatient" id="StudyPatient" value="1"
                                        class="custom-control-input">
                                    <span class="custom-control-label">Study Patient</span>
                                </label>

                            </div>
                        </div>
                        <div class="col-lg-8">
                            <span class="form-group">
                                <label class="floating-label">Optometrist</label>
                                <!-- Multiple -->

                                <select class="select2-demo form-control select2-hidden-accessible"
                                    style="width: 100%;height:35px;" data-allow-clear="true" name="ConfirmOpto"
                                    id="ConfirmOpto">

                                    <option value="0">None
                                    </option>
                                    @foreach($optometristList as $result)
                                    <option value="{{$result->id}}">{{$result->Name}}</option>
                                    @endforeach
                                </select>
                            </span>
                        </div>
                    </div>


                </fieldset>
            </div>

            <div class="col-md-12 mb-4">
                <fieldset>
                    <legend></legend>
                    <div class="col-sm-12">
                        <button class="btn btn-primary" id="submit" type="submit" name="submit">Save</button>
                        <button class="btn btn-success" onclick="printOt()" id="printbtn" type="button"
                            disabled>Print</button>
                        <button class="btn btn-danger" type="button" onclick="dischargeCard({{$MrdNo}})" id="discbtn"
                            disabled>Discharge
                            Card</button>
                        <button class="btn btn-secondary" type="button" onclick="dischargeCard()" id="discbtn"
                            disabled>IPD Receipt
                            Card</button>
                        <button class="btn btn-danger" type="button" onclick="dischargeCard()" id="discbtn" disabled>IPD
                            Bill
                        </button>
                    </div>
                </fieldset>
            </div>
        </div>

        <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">






    </form>
</div>
</div>
</div>
<!-- [ Layout content ] Start -->

</div>
<!-- [ Layout container ] End -->

</div>
<!-- Overlay -->

<div class="layout-overlay layout-sidenav-toggle"></div>
</div>
<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/inccommonmodal')
<div class="layout-overlay layout-sidenav-toggle"></div><!-- [ Layout wrapper] End -->
<!-- Modal -->
@include('footerscript')
<script>
$('.datalist').on('click', function() {
    $(this).val('');
});

function companyLists() {
    $.ajax({
        url: "{{ url('companyLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#IolName').html(data);
        }
    });
}
function modelLists(Cname,IolType) {
    //var Cname = $('#IolName').val();
    $.ajax({
        url: "{{ url('modelLists2') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Cname: Cname
        },
        success: function(data) {
            
            $('#IolType').html(data);
            $('#IolType').val(IolType).attr("selected",true);
        }
    });
}

function powerLists(Model,Power) {
    //var Cname = $('#IolName').val();
    //var Model = $('#IolType').val();
    $.ajax({
        url: "{{ url('powerLists2') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Model: Model
        },
        success: function(data) {
            $('#IolPower').html(data);
            $('#IolPower').val(Power).attr("selected",true);
        }
    });
}
function dlRestoreValue(i) {

    let t = $('#' + i);
    if (t.val() === '') {

        if (t.attr('org-placeholder') !== t.attr('placeholder')) {
            t.val(t.attr('placeholder'));
        }

        t.attr('placeholder', '');
        if (t.val() === '') {
            t.attr('placeholder', t.attr('org-placeholder'));
        }

    }

}

function dlShowAllOnArrowClick(i) {

    $('#' + i)
        .on('click', function(e) {

            let t = $(this);
            if ((t.width() - (e.clientX - t.offset().left)) < 14) {
                if (t.val() !== "") {
                    t.attr('placeholder', t.val());
                    t.val('');
                }
            } else {
                dlRestoreValue(i)
            }
        })

        .on('mouseleave', function() {
            dlRestoreValue(this.id);
        })


        .on('mouseenter', function() {
            if (!$(this).is("[org-placeholder]")) $(this).attr('org-placeholder', $(this).attr('placeholder'));
        })

}


dlShowAllOnArrowClick('cmbdialatedwith');
dlShowAllOnArrowClick('cmbhearingstatus');
dlShowAllOnArrowClick('cmbpupdilation');
dlShowAllOnArrowClick('cmbsocket');

function dischargeCard(mrdno) {
    var otid = $('#saveid').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}addDischargeCard2/' + mrdno + '/' + otid, 'popUpWindow3',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function printOt() {
    var id = $('#saveid').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printOtNotes/' + id, 'popUpWindow2',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function getValue(val, idval) {
    $('#ModalValue').val(val);
    $('#ValueId').val(idval);
    $('#OldValue').val('');
    desc_lists(val);
}

function getRecords(val) {
    $.ajax({
        url: "{{ url('getTreatments') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Treatment: val
        },
        success: function(data) {
            console.log(data);
            $('#showTreatments').html(data);
        }
    });
}

function getPatientDetails(val) {
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            $('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName);
            $('#Age').val( data.Age);
            $('#Gender').val(data.Gender);
            $('#Phone').val(data.Phone);
            $('#Address').val(data.Address);
            //getPatientTreatment(data.MrdNo);
        }
    });
}

function checkLastOtPatient(val){
    var CurrDate = $('#CurrDate').val();
    $.ajax({
        url: "{{ url('checkLastOtPatient') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            if(data == 0){
                blankField()
                $('#CreatedDate').val(CurrDate);
                $('#actionvalue').val('Save');
    $('#saveid').val('');
    $('#printbtn').attr("disabled", true);
                $('#discbtn').attr("disabled", true);
            }
            else{
                $('#actionvalue').val('Edit');
                $('#IolName').val(data.IolName).attr("selected",true);
            modelLists(data.IolName,data.IolType);
            powerLists(data.IolType,data.IolPower);
    $('#saveid').val(data.id);
    $('#printbtn').attr("disabled", false);
                $('#discbtn').attr("disabled", false);
                $('#CreatedDate').val(data.CreatedDate);
                $('#CreatedTime').val(data.CreatedTime);
                $('#Diagnosis').val(data.Diagnosis);
                $('#Bs').val(data.Bs);
                $('#Bp').val(data.Bp);
                $('#IopRe').val(data.IopRe);
                $('#IopLe').val(data.IopLe);
                $('#Other').val(data.Other);
                $('#Category').val(data.Category);
                $('#K1Re').val(data.K1Re);
                $('#K1Le').val(data.K1Le);
                $('#K2Re').val(data.K2Re);
                $('#K2Le').val(data.K2Le);
                $('#AL').val(data.AL);
                $('#Acd').val(data.Acd);
                //$('#IolPower').val(data.IolPower);
                $('#Formula').val(data.Formula);
                $('#Aconstant').val(data.Aconstant);
                $('#Surgeon').val(data.Surgeon);
                $('#Assistant').val(data.Assistant);
                $('#Anaethetist').val(data.Anaethetist);
                $('#Package').val(data.Package);
                $('#SurgeryPerformed').val(data.SurgeryPerformed);
                $('#DilatedBy').val(data.DilatedBy);
                $('#AnesthesiaType').val(data.AnesthesiaType);
                $('#Draping').val(data.Draping);
                $('#Speculum').val(data.Speculum);
                $('#ConjunctivalWash').val(data.ConjunctivalWash);
                $('#SideportIncision').val(data.SideportIncision);
                $('#Viscoelastic').val(data.Viscoelastic);
                $('#ccc').val(data.ccc);
                $('#CapStaining').val(data.CapStaining);
                $('#IrrigationSol').val(data.IrrigationSol);
                $('#Hydroscetion').val(data.Hydroscetion);
                $('#Nucleus').val(data.Nucleus);
                $('#CorticalWash').val(data.CorticalWash);
                $('#Lri').val(data.Lri);
                $('#WoundHydration').val(data.WoundHydration);
                $('#Intracameral').val(data.Intracameral);
                $('#PkgAmt').val(data.PkgAmt);
                $('#InsComp').val(data.InsComp);
                $('#ReqAmt').val(data.ReqAmt);
                $('#SanctAmt').val(data.SanctAmt);
                $('#AddAmt').val(data.AddAmt);
                $('#SettleAmt').val(data.SettleAmt);
                $('#SettleDate').val(data.SettleDate);
                $('#UtrNo').val(data.UtrNo);
                $('#ProcedureComments').val(data.ProcedureComments);
                $('#Remarks').val(data.Remarks);
                //$('#IolName').val(result.IolName);
                //$('#IolType').val(result.IolType);
                if (result.StudyPatient == 1) {
                    $('#StudyPatient').prop("checked", true);
                } else {
                    $('#StudyPatient').prop("checked", false);
                }

                $('#ConfirmOpto').val(result.ConfirmOpto).attr("selected", true);
            }
        }
    });
}

function blankField() {
    $('#actionvalue').val('Save');
    $('#saveid').val('');
    $('#printbtn').attr("disabled", true);
    $('#discbtn').attr("disabled", true);
    //$('#cmbtreateye').val('').attr("selected",true);
    $('#Eye').val('');
    $('#Diagnosis').val('');
    $('#Bs').val('');
    $('#Bp').val('');
    $('#IopRe').val('');
    $('#IopLe').val('');
    $('#Other').val('');
    $('#Category').val('');
    $('#K1Re').val('');
    $('#K1Le').val('');
    $('#K2Re').val('');
    $('#K2Le').val('');
    $('#AL').val('');
    $('#Acd').val('');
    $('#IolPower').val('').attr("selected", true);
    $('#Formula').val('');
    $('#Aconstant').val('');
    $('#Surgeon').val('');
    $('#Assistant').val('');
    $('#Anaethetist').val('');
    $('#Package').val('');
    $('#SurgeryPerformed').val('');
    $('#DilatedBy').val('');
    $('#AnesthesiaType').val('');
    $('#Draping').val('');
    $('#Speculum').val('');
    $('#ConjunctivalWash').val('');
    $('#SideportIncision').val('');
    $('#Viscoelastic').val('');
    $('#ccc').val('');
    $('#CapStaining').val('');
    $('#IrrigationSol').val('');
    $('#Hydroscetion').val('');
    $('#Nucleus').val('');
    $('#CorticalWash').val('');
    $('#Lri').val('');
    $('#WoundHydration').val('');
    $('#Intracameral').val('');
    $('#PkgAmt').val('');
    $('#InsComp').val('');
    $('#ReqAmt').val('');
    $('#SanctAmt').val('');
    $('#AddAmt').val('');
    $('#SettleAmt').val('');
    $('#SettleDate').val(CurrDate);
    $('#UtrNo').val('');
    $('#ProcedureComments').val('');
    $('#Remarks').val('');
    $('#IolName').val('').attr("selected", true);
    $('#IolType').val('').attr("selected", true);
    $('#StudyPatient').val('');
    $('#ConfirmOpto').val('').attr("selected", true);
    $('#CreatedTime').val('');
   
}

$(document).ready(function() {
    companyLists();
    var MrdNo = $('#MrdNo').val();
    getPatientDetails(MrdNo);
    checkLastOtPatient(MrdNo);
    //getPrevVisitDetails(MrdNo);
    //var eye = $('#cmbtreateye').val();
    //checkOtPatient(MrdNo, eye);
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveOtNotes') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    $('#actionvalue').val('Edit');
                    $('#saveid').val(data);
                    $('#printbtn').attr("disabled", false);
                    $('#discbtn').attr("disabled", false);
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');

                }
            });
        }

    });



    $(document).on("shown.bs.modal", "#modal-report", function() {
        $('#search_text77').focus();
    });



});
</script>