@extends('layout')

@section('content')
@php
$UserId = Session::get('UserId');
if(file_exists('json_files/json-file.json')){
$json = file_get_contents('json_files/json-file.json');
//Decode JSON
$json_data = json_decode($json,true);
$results = array();
}

if(file_exists('json_files/timetables_date.json')){
$json2 = file_get_contents('json_files/timetables_date.json');
//Decode JSON
$json_data2 = json_decode($json2,true);
$results2 = array();
}
@endphp
<style type="text/css">
fieldset legend {
    background: inherit;
    font-family: "Lato", sans-serif;
    color: #650812;
    font-size: 15px;
    left: 10px;
    padding: 0 10px;
    position: absolute;
    top: -12px;
    font-weight: 400;
    width: auto !important;
    border: none !important;
}

fieldset {
    background: #ffffff;
    border: 1px solid #C43853;
    border-radius: 5px;
    margin: 20px 0 1px 0;
    padding: 25px;
    position: relative;
}

.form-control {
    min-height: 1px;
    height: 25px;
}

.table th,
.table td {
    padding: 0.325rem;
}
</style>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Edit Discharge Card</h4>
    <form method="POST" action="/{{projectUrl()}}saveDischargeCard">
    <input type="hidden" name="actionvalue" value="Edit">
        <input type="hidden" name="saveid" id="saveid" value="{{$data2->id}}">
        @csrf
        <div class="row">
            <div class="col-md-4">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                    <input value="" class="form-control" list="DataList2" name="PatientId" id="PatientId" style="height: 31px;">
                    <datalist id="DataList2">
                        @foreach($patientList as $result)
                        @if($result->Phone == '')
                        <?php $PatientName = $result->MrdNo." / ".$result->PatientName;?>
                        @else
                        <?php $PatientName = $result->MrdNo." / ".$result->PatientName."/".$result->Phone;?>
                        @endif
                        <option value="{{$PatientName}}">
                            @endforeach
                    </datalist>
                    </div>

                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                        <select class="form-control" name="OtNotes" id="OtNotes" style="height:31px;">
                            <option value="O.T Notes" <?php if($data2->OtNotes == 'O.T Notes'){?> selected <?php } ?>>O.T Notes</option>

                            <option value="O.T Notes Other" <?php if($data2->OtNotes == 'O.T Notes Other'){?> selected <?php } ?>>O.T Notes Other</option>
                        </select>
                    </div>

                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                        <select class="form-control" name="OptEye" id="OptEye" style="height:31px;">
                            <option value="R.E" <?php if($data2->OptEye == 'R.E'){?> selected <?php } ?>>R.E</option>

                            <option value="L.E" <?php if($data2->OptEye == 'L.E'){?> selected <?php } ?>>L.E</option>
                        </select>
                    </div>

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 mb-1">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>


                                <tr>


                                    <th width="10" align="center" valign="top">Mrd.No </th>
                                    <th width="50" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="MrdNo" name="MrdNo" readonly value="{{$data2->MrdNo}}">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Patient Name </th>
                                    <th width="180" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" name="PatientName" id="PatientName" value="{{$data2->PatientName}}" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Age/Gender </th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="AgeGender" name="AgeGender" value="{{$data2->AgeGender}}" readonly>
                                    <th width="30" align="center" valign="top">Mobile</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Phone" name="Mobile" value="{{$data2->Mobile}}" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Address</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Address" name="Address" value="{{$data2->Address}}" readonly>
                                        <div class="clearfix"></div>
                                    </th>
                                </tr>

                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 mb-1">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>

                                <tr>
                                    <th width="175" align="center" valign="top">Date of Admission </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="AdmissionDate"
                                            class="form-control" id="AdmissionDate" value="{{$data2->AdmissionDate}}"></th>

                                    <th width="126" align="center" valign="top">Date of Operation </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="OperationDate"
                                            id="OperationDate" class="form-control" value="{{$data2->OperationDate}}"></th>
                                    <th width="194" align="center" valign="top">Date of Discharge </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="DischargeDate"
                                            class="form-control" id="DischargeDate" value="{{$data2->DischargeDate}}"></th>
                                    <th width="194" align="center" valign="top">Follow up Date </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="FollowUpDate1"
                                            class="form-control" id="FollowUpDate1" value="{{$data2->FollowUpDate1}}"></th>
                                </tr>


                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="row">
                    <div class="col-lg-5">
                    <div class="row">    
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Diagnosis</legend>
                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="form-group">
                                            <textarea class="form-control" placeholder="Search for..." name="Diagnosis"
                                                id="Diagnosis">{{$data2->Diagnosis}}</textarea>

                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <span class="input-group-append">
                                            <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                data-target="#modal-report" id="add_button"
                                                onclick="getValue('Diagnosis','Diagnosis')">...</button>
                                        </span>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Surgery Performed</legend>
                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="form-group">
                                            <textarea class="form-control" placeholder="Search for..." name="SurgeryPerformed"
                                                id="SurgeryPerformed">{{$data2->SurgeryPerformed}}</textarea>

                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <span class="input-group-append">
                                            <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                data-target="#modal-report" id="add_button"
                                                onclick="getValue('SurgeryPerformed','SurgeryPerformed')">...</button>
                                        </span>
                                    </div>
                                </div>


                            </fieldset>
                        </div>

                        <div class="col-md-12">
                            <fieldset>
                                <legend>Condition on Discharge</legend>
                                <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="CondDischarge" id="CondDischarge">{{$data2->CondDischarge}}</textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('CondDischarge','CondDischarge')">...</button>
                                            </span>
                                        </div>
                                    </div>


                            </fieldset>
                        </div>

                    


                        <div class="col-md-12">
                            <fieldset>
        <button class="btn btn-primary" type="submit">Submit</button>
        <button class="btn btn-success" type="button" onclick="print({{$data2->id}})">Print</button>
        <button class="btn btn-danger">Clear</button>
        </fieldset>
    </div>




                        </div>
                    </div>
                    

                    <div class="col-lg-7">
                    <div class="row">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Investigation</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="50" align="center" valign="top">B.S</th>
                                                <th width="100" align="center" valign="top">
                                                    <input class="form-control" type="text" list="bsrndm"
                                                        name="cmbbsrandom" id="cmbbsrandom" value="{{$data2->cmbbsrandom}}">
                                                    <datalist id="bsrndm">

                                                        <option value="Random">
                                                        <option value="Fasting">
                                                    </datalist>
                                                </th>
                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="txtbsfasting" class="form-control"
                                                        placeholder="Text input" value="{{$data2->txtbsfasting}}">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">U.S </th>
                                                <th width="100" align="center" valign="top">
                                                    <input class="form-control" type="text" list="usrndm"
                                                        name="cmbusrandom" id="cmbusrandom" value="{{$data2->cmbusrandom}}">
                                                    <datalist id="usrndm">

                                                        <option value="Random">
                                                        <option value="Fasting">
                                                    </datalist>
                                                </th>
                                                <th width="105" align="center" valign="top"><input type="text"
                                                        name="txtusfasting" class="form-control"
                                                        placeholder="Text input" value="{{$data2->txtusfasting}}">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="100" align="center" valign="top">HbS Ag</th>
                                                <th width="105" align="center" valign="top"> <input class="form-control"
                                                        type="text" list="hbsag" name="cmbhbsag" id="cmbhbsag" value="{{$data2->cmbhbsag}}">
                                                    <datalist id="hbsag">

                                                        <option value="Postive">
                                                        <option value="Negative">
                                                    </datalist>
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">B.P </th>
                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="txtbp" class="form-control" placeholder="Text input"
                                                        value="{{$data2->txtbp}}">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>



                                            </tr>
                                            <tr>
                                                <th width="50" align="center" valign="top">B.S</th>
                                                <th width="100" align="center" valign="top"><input class="form-control"
                                                        type="text" list="bspostmeal" name="cmbbspostmeal"
                                                        id="cmbbspostmeal" value="{{$data2->cmbbspostmeal}}">
                                                    <datalist id="bspostmeal">

                                                        <option value="Post Meal">
                                                    </datalist>
                                                </th>
                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="txtbspostmeal" class="form-control"
                                                        placeholder="Text input" value="{{$data2->txtbspostmeal}}">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">U.S</th>
                                                <th width="100" align="center" valign="top"><input class="form-control"
                                                        type="text" list="uspostmeal" name="cmbuspostmeal"
                                                        id="cmbuspostmeal" value="{{$data2->cmbuspostmeal}}">
                                                    <datalist id="uspostmeal">

                                                        <option value="Post Meal">
                                                    </datalist>
                                                </th>
                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="txtuspostmeal" class="form-control"
                                                        placeholder="Text input" value="{{$data2->txtuspostmeal}}"></th>
                                                <th width="100" align="center" valign="top">E.C.G</th>
                                                <th width="105" align="center" valign="top"><input class="form-control"
                                                        type="text" list="ecg" name="cmbecg" id="cmbecg" value="{{$data2->cmbecg}}">
                                                    <datalist id="ecg">

                                                        <option value="Normal">
                                                    </datalist>
                                                </th>
                                                <th width="50" align="center" valign="top">HIV</th>
                                                <th width="105" align="center" valign="top"><input class="form-control"
                                                        type="text" list="hiv" name="cmbhiv" id="cmbhiv" value="{{$data2->cmbhiv}}">
                                                    <datalist id="hiv">

                                                    <option value="+ VE">
                                                        <option value="- VE">
                                                    </datalist>
                                                </th>


                                            </tr>
                                            <tr>
                                                <th width="50" align="center" valign="top">Fitness By</th>

                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="txtfitnessby" class="form-control"
                                                        placeholder="Text input" value="{{$data2->txtfitnessby}}">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">Other</th>

                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="txtother" class="form-control" placeholder="Text input"
                                                        value="{{$data2->txtother}}"></th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>


                            </fieldset>
                        </div>
                        

                            <div class="col-md-12">
                                <fieldset>
                                    <legend>Lens Details</legend>
                                    <div class="row">
                                        <table class="table table-bordered table-striped mb-0">
                                            <thead>

                                                <tr>
                                                    <th width="50" align="center" valign="top">IOL Power</th>

                                                    <th width="113" align="center" valign="top"><input type="text"
                                                            name="IolPower" class="form-control" placeholder="Text input"
                                                            value="{{$data2->IolPower}}">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                    <th width="50" align="center" valign="top">Cyl For Toric </th>

                                                    <th width="105" align="center" valign="top"><input type="text"
                                                            name="CylToric" class="form-control"
                                                            placeholder="Text input" value="{{$data2->CylToric}}">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                    <th width="100" align="center" valign="top">Axis</th>
                                                    <th width="105" align="center" valign="top"><input type="text"
                                                            name="Axis" class="form-control"
                                                            placeholder="Text input" value="{{$data2->Axis}}">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                    <th width="50" align="center" valign="top">Add for Mutifocal </th>
                                                    <th width="129" align="center" valign="top"><input type="text"
                                                            name="Multifocal" class="form-control" placeholder="Text input"
                                                            value="{{$data2->Multifocal}}">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>



                                                </tr>
                                                <tr>
                                                    <th width="50" align="center" valign="top">A constant</th>

                                                    <th width="129" align="center" valign="top"><input type="text"
                                                            name="Constant" class="form-control" placeholder="Text input"
                                                            value="{{$data2->Constant}}">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                    <th width="50" align="center" valign="top">IOP (RE)</th>

                                                    <th width="113" align="center" valign="top"><input type="text"
                                                            name="IopRe" class="form-control" placeholder="Text input"
                                                            value="{{$data2->IopRe}}"></th>
                                                    <th width="100" align="center" valign="top">IOP (LE)</th>
                                                    <th width="105" align="center" valign="top"><input type="text"
                                                            name="IopLe" class="form-control"
                                                            placeholder="Text input" value="{{$data2->IopLe}}"></th>



                                                </tr>

                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>


                                </fieldset>
                            </div>

                            <div class="col-md-12">
                            @include('opd/incedittreatments')
                            </div>
                        
                        </div>
                        <div>

                        </div>

                        </div>
                    </div></div>


                    

                      

    </form>
</div>
</div>
</div>
<!-- [ Layout content ] Start -->

</div>
<!-- [ Layout container ] End -->

</div>
<!-- Overlay -->

<div class="layout-overlay layout-sidenav-toggle"></div>
</div>
<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/inccommonmodal')
@include('masters/incdrugmodal')
@endsection
@section('scriptcontent')
<script>
    function saveDrug(){
            var Type = $('#DrugType').val();
            var Name = $('#DrugName').val();
            var Dose = $('#DrugDose').val();
            var Freq = $('#DrugFreq').val();
            var MrdNo = $('#MrdNo').val();
            var VisitDate = $('#VisitDate').val();
            var VisitNo = $('#VisitNo').val();
            var saveid = $('#saveid').val();
            var action = 'Save';
            $.ajax({
            url: "{{ url('saveDrug') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                Type: Type,
                Name:Name,
                Dose:Dose,
                Freq:Freq,
                action:action
            },
            beforeSend: function() {
                    $('#drugbtn').attr('disabled', 'disabled');
                    $('#drugbtn').text('Please Wait...');
                },
            success: function(data) {
                $('#modal-report656').modal('hide');
                    
                    $('#drugbtn').attr('disabled', false);
                    $('#drugbtn').text('Submit');
                    window.location.href = "/{{projectUrl()}}editDischargeCard/" + saveid;  
               
            }
        });
        }
    function print(id){
        setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printDischargeCard/' + id , 'name',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
        );
    }, 1);
    }
    function getValue(val, idval) {
        $('#ModalValue').val(val);
        $('#ValueId').val(idval);
        $('#OldValue').val('');
        $('#search_text77').val('');
        $('#Ref_By').focus();
        desc_lists(val);
    }



function getRecords(val) {
    $.ajax({
        url: "{{ url('getTreatments') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Treatment: val
        },
        success: function(data) {
            console.log(data);
            $('#showTreatments').html(data);
        }
    });
}

function getPatientTreatment(val){
    $.ajax({
            url: "{{ url('getPatientTreatment') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            success: function(data) {
                var res = JSON.parse(data);
                var result = res.data;
                var Diagnosis = res.Diagnosis;
                $('#Diagnosis').val(Diagnosis);
                $('#Treatment').val(result.Treatment);
                if(result.TreatChk1 == 1){
                $('#TreatChk1').prop("checked", true);
                }
                else{
                $('#TreatChk1').prop("checked", false);    
                }
                $('#TreatType1').val(result.TreatType1);
                $('#TreatName1').val(result.TreatName1);
                $('#TreatDose1').val(result.TreatDose1);
                $('#TreatFreq1').val(result.TreatFreq1);
                $('#TreatDur1').val(result.TreatDur1);
                $('#TreatEye1').val(result.TreatEye1);

                if(result.TreatChk2 == 1){
                $('#TreatChk2').prop("checked", true);
                }
                else{
                $('#TreatChk2').prop("checked", false);    
                }
                $('#TreatType2').val(result.TreatType2);
                $('#TreatName2').val(result.TreatName2);
                $('#TreatDose2').val(result.TreatDose2);
                $('#TreatFreq2').val(result.TreatFreq2);
                $('#TreatDur2').val(result.TreatDur2);
                $('#TreatEye2').val(result.TreatEye2);

                if(result.TreatChk3 == 1){
                $('#TreatChk3').prop("checked", true);
                }
                else{
                $('#TreatChk3').prop("checked", false);    
                }
                $('#TreatType3').val(result.TreatType3);
                $('#TreatName3').val(result.TreatName3);
                $('#TreatDose3').val(result.TreatDose3);
                $('#TreatFreq3').val(result.TreatFreq3);
                $('#TreatDur3').val(result.TreatDur3);
                $('#TreatEye3').val(result.TreatEye3);

                if(result.TreatChk4 == 1){
                $('#TreatChk4').prop("checked", true);
                }
                else{
                $('#TreatChk4').prop("checked", false);    
                }
                $('#TreatType4').val(result.TreatType4);
                $('#TreatName4').val(result.TreatName4);
                $('#TreatDose4').val(result.TreatDose4);
                $('#TreatFreq4').val(result.TreatFreq4);
                $('#TreatDur4').val(result.TreatDur4);
                $('#TreatEye4').val(result.TreatEye4);

                if(result.TreatChk5 == 1){
                $('#TreatChk5').prop("checked", true);
                }
                else{
                $('#TreatChk5').prop("checked", false);    
                }
                $('#TreatType5').val(result.TreatType5);
                $('#TreatName5').val(result.TreatName5);
                $('#TreatDose5').val(result.TreatDose5);
                $('#TreatFreq5').val(result.TreatFreq5);
                $('#TreatDur5').val(result.TreatDur5);
                $('#TreatEye5').val(result.TreatEye5);

                if(result.TreatChk6 == 1){
                $('#TreatChk6').prop("checked", true);
                }
                else{
                $('#TreatChk6').prop("checked", false);    
                }
                $('#TreatType6').val(result.TreatType6);
                $('#TreatName6').val(result.TreatName6);
                $('#TreatDose6').val(result.TreatDose6);
                $('#TreatFreq6').val(result.TreatFreq6);
                $('#TreatDur6').val(result.TreatDur6);
                $('#TreatEye6').val(result.TreatEye6);

                if(result.TreatChk7 == 1){
                $('#TreatChk7').prop("checked", true);
                }
                else{
                $('#TreatChk7').prop("checked", false);    
                }
                $('#TreatType7').val(result.TreatType7);
                $('#TreatName7').val(result.TreatName7);
                $('#TreatDose7').val(result.TreatDose7);
                $('#TreatFreq7').val(result.TreatFreq7);
                $('#TreatDur7').val(result.TreatDur7);
                $('#TreatEye7').val(result.TreatEye7);

                if(result.TreatChk8 == 1){
                $('#TreatChk8').prop("checked", true);
                }
                else{
                $('#TreatChk8').prop("checked", false);    
                }
                $('#TreatType8').val(result.TreatType8);
                $('#TreatName8').val(result.TreatName8);
                $('#TreatDose8').val(result.TreatDose8);
                $('#TreatFreq8').val(result.TreatFreq8);
                $('#TreatDur8').val(result.TreatDur8);
                $('#TreatEye8').val(result.TreatEye8);

                if(result.TreatChk9 == 1){
                $('#TreatChk9').prop("checked", true);
                }
                else{
                $('#TreatChk9').prop("checked", false);    
                }
                $('#TreatType9').val(result.TreatType9);
                $('#TreatName9').val(result.TreatName9);
                $('#TreatDose9').val(result.TreatDose9);
                $('#TreatFreq9').val(result.TreatFreq9);
                $('#TreatDur9').val(result.TreatDur9);
                $('#TreatEye9').val(result.TreatEye9);

                if(result.TreatChk10 == 1){
                $('#TreatChk10').prop("checked", true);
                }
                else{
                $('#TreatChk10').prop("checked", false);    
                }
                $('#TreatType10').val(result.TreatType10);
                $('#TreatName10').val(result.TreatName10);
                $('#TreatDose10').val(result.TreatDose10);
                $('#TreatFreq10').val(result.TreatFreq10);
                $('#TreatDur10').val(result.TreatDur10);
                $('#TreatEye10').val(result.TreatEye10);
            }
        });
}

$(document).ready(function() {
    $(document).on("input", "#Treatment", function(event) {
        var val = $(this).val();
        getRecords(val);
    });

    $(document).on("change", "#PatientId", function(event) {
        var val = this.value;
        $.ajax({
            url: "{{ url('getPatientDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            dataType: "json",
            success: function(data) {
                var AgeGender = data.Age + "/" + data.Gender;
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#AgeGender').val(AgeGender);
                $('#Phone').val(data.Phone);
                $('#Address').val(data.Address);
                getPatientTreatment(data.MrdNo);
            }
        });

    });



});
</script>

@endsection