<!DOCTYPE html>
<html>
<head>
    <meta charset="iso-8859-1" />
    <title>OT List</title>

    <style>
        body {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            margin: 20px;
        }

        .style2 {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            display: block;
            margin-bottom: 10px;
        }

        .button-container {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-bottom: 10px;
        }

        button {
            padding: 8px 16px;
            font-size: 14px;
            cursor: pointer;
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #000;
            padding: 10px 8px;
            font-size: 13px;
        }

        thead tr {
            background-color: #d3d3d3;
        }

        tbody tr:nth-child(even) {
            background-color: #ffffff;
        }

        tbody tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        @media print {
            @page {
                size: landscape;
                margin: 10mm;
            }

            body {
                font-size: 11px;
            }

            table, th, td {
                font-size: 10px;
                padding: 4px;
            }

            .noPrint {
                display: none !important;
            }
        }

        @media screen {
            div.divFooter {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="button-container noPrint">
        <button onclick="window.print()">🖨️ Print</button>
        <button onclick="exportTableToExcel('otTable', 'Counselling_List')">📤 Export Excel</button>
    </div>

    <span class="style2">OT LIST</span>
    <div>Date: {{ date("d/m/Y", strtotime(str_replace('-', '/',$fromdate))) }}</div>

    <div class="table-container">
        <table id="otTable">
            <thead>
                <tr>
                    <th>Sr.No</th>
                    <th>MRD No</th>
                    <th>Surgery Dt.</th>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Age</th>
                    <th>Surgery Name</th>
                    <th>Ansth</th>
                    <th>Site</th>
                    <th>Surgeon</th>
                    <th>Remark</th>
                    <th>IOL</th>
                    <th>Type</th>
                    <th>Surgery Charges</th>
                   <th>Counselor</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $i = 1;
                use App\Http\Controllers\ConsentController;
                foreach ($data as $result) {
                    $SurgeonName = $result->SurgeonName;
                    $docname = (new ConsentController)->getSurgeonName($SurgeonName);
                ?>
                <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $result->MrdNo }}</td>
                    <td>{{ date("d/m/Y", strtotime(str_replace('-', '/', $result->SurgeryDate))) }}</td>
                    <td>{{ strtoupper(strtolower($result->PatientName)) }}</td>
                    <td>{{ $result->Phone }}</td>
                    <td>{{ $result->Age }}</td>
                    <td>{{ $result->SurgeryName }}</td>
                    <td>{{ $result->Anaesthetist }}</td>
                    <td>{{ $result->Eye }}</td>
                    <td>{{ $docname }}</td>
                    <td>{{ strtoupper(strtolower($result->Remarks)) }}</td>
                    <td><?= $result->Iol ?></td>
                    <td>
    @if(!empty($result->payment_type1)) {{ $result->payment_type1 }}<br> @endif
    @if(!empty($result->payment_type2)) {{ $result->payment_type2 }}<br> @endif
    @if(!empty($result->payment_type3)) {{ $result->payment_type3 }}<br> @endif
    @if(!empty($result->payment_type4)) {{ $result->payment_type4 }} @endif
</td>
                    <td>{{ $result->SurgeryCharges }}</td>
                    <td>{{ $result->CounsellingDoneBy }}</td>
                </tr>
                <?php $i++; } ?>
            </tbody>
        </table>
    </div>

    <script>
        function exportTableToExcel(tableID, filename = '') {
            const dataType = 'application/vnd.ms-excel';
            const table = document.getElementById(tableID);

            // Apply borders and spacing in Excel
            let html = '<table border="1" style="border-collapse:collapse;">';
            html += table.innerHTML;
            html += '</table>';

            const blob = new Blob(['\ufeff', html], { type: dataType });

            // File name
            filename = filename ? filename + '.xls' : 'Counselling_List.xls';

            const downloadLink = document.createElement('a');
            downloadLink.href = URL.createObjectURL(blob);
            downloadLink.download = filename;
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        }

        window.onafterprint = window.close;
    </script>
</body>
</html>
