@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Lense Stock In</h4>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center m-l-0">



                        <div class="col-sm-2 text-left">
                            <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                                data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add
                                New Lense</button>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-label">From Date </label>
                            <input type="date" name="FromDate" id="FromDate" class="form-control"
                                value="{{date('Y-m-d')}}" autocomplete="off" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-label">To Date </label>
                            <input type="date" name="ToDate" id="ToDate" class="form-control" value="{{date('Y-m-d')}}"
                                autocomplete="off" required>
                        </div>
                        <input type="hidden" name="Search" value="Search">
                        <div class="form-group col-md-2" style="padding-top:20px;">
                            <button type="button" id="filter" class="btn btn-primary btn-finish">Search</button>
                        </div>


                    </div>
                    <hr>
                    <div class="table-responsive" id="custresult">

                    </div>
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>


    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width: 70rem; ">
            <div class="modal-content">


                <div class="modal-header">
                    <h5 class="modal-title">Add Lense</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="validation-form" method="POST" action="" autocomplete="off">
                        @csrf
                        <div class="row">

                            <input type="hidden" name="action" id="action" value="Save">
                            <input type="hidden" name="id" id="id" />
                            <input type="hidden" name="TransType" id="TransType" />

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Vendor Name <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="VedDataList" name="VedName" id="VedName" value=""
                                        >
                                    <datalist id="VedDataList">

                                    </datalist>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">IOL Company Name <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="CompDataList" name="IolCompName" id="IolCompName" value=""
                                        >
                                    <datalist id="CompDataList">

                                    </datalist>
                                </div>
                            </div>


                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">IOL Name <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="DataList" name="Cname" id="Cname" value=""
                                        oninput="modelLists()">
                                    <datalist id="DataList">

                                    </datalist>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">IOL Type <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="DataList2" name="Model" id="Model" value=""
                                        oninput="powerLists()">
                                    <datalist id="DataList2">

                                    </datalist>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Sr No </label>
                                    <input class="form-control" name="SrNo" id="SrNo" value="">
                                    
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Power <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="DataList3" name="Power" id="Power" value="">
                                    <datalist id="DataList3">

                                    </datalist>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Expiry Date <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <select class="form-control" name="ExpMonth" id="ExpMonth">
                                            <option selected disabled value="">Month</option>
                                            @for($i=1;$i<=12;$i++) <option value="{{$i}}">{{$i}}</option>
                                                @endfor
                                        </select>
                                        <input type="text" class="form-control" name="ExpYear" id="ExpYear"
                                            placeholder="Year">
                                    </div>

                                </div>

                            </div> 

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Stock In Date <span
                                            class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="StockDate" id="StockDate"
                                        placeholder="" required="">
                                </div>
                            </div>

                            {{-- <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Expiry Date <span
                                            class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="ExpiryDate" id="ExpiryDate"
                                        placeholder="" required="">
                                </div>
                            </div> --}}

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Quantity <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Quantity" id="Quantity" placeholder=""
                                        required="">
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Bill No </label>
                                    <input type="text" class="form-control" name="BillNo" id="BillNo" placeholder=""
                                        >
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Bill Date </label>
                                    <input type="date" class="form-control" name="BillDate" id="BillDate" placeholder=""
                                        >
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Amount <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Amount" id="Amount" placeholder=""
                                        required="">
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Narration</label>
                                    <input type="text" class="form-control" name="Narration" id="Narration"
                                        placeholder="">
                                </div>
                            </div>

                            <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">
                            <div class="col-sm-12">
                                <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                                <button class="btn btn-danger" type="reset">Clear</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</div>

@include('footerscript')
<script>
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'Stock Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Record Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function vendorLists() {
    $.ajax({
        url: "{{ url('vendorLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#VedDataList').html(data);
        }
    });
}

function iolCompanyLists() {
    $.ajax({
        url: "{{ url('iolCompanyLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#CompDataList').html(data);
        }
    });
}


function companyLists() {
    $.ajax({
        url: "{{ url('companyLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#DataList').html(data);
        }
    });
}

function modelLists() {
    var Cname = $('#Cname').val();
    $.ajax({
        url: "{{ url('modelLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Cname: Cname
        },
        success: function(data) {
            $('#DataList2').html(data);
        }
    });
}

function powerLists() {
    var Cname = $('#Cname').val();
    var Model = $('#Model').val();
    $.ajax({
        url: "{{ url('powerLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Cname: Cname,
            Model: Model
        },
        success: function(data) {
            $('#DataList3').html(data);
        }
    });
}

function procedure_lists(FromDate = '', ToDate = '') {
    var CrDr = 'D';
    $.ajax({
        url: "{{ url('viewLenseStockList') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            FromDate: FromDate,
            ToDate: ToDate,
            CrDr: CrDr
        },
        success: function(data) {
            $('#custresult').html(data);
        }
    });
}

$(document).ready(function() {
    $('#modal-report').modal('show');
    var CurrDate = $('#CurrDate').val();
    $('#StockDate').val(CurrDate);
    $('#filter').click(function() {
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        if (FromDate != '' && ToDate != '') {
            //$('.yajra-datatable').DataTable().destroy();
            //load_data(FromDate, ToDate);
            procedure_lists(FromDate, ToDate);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh').click(function() {
        $('#FromDate').val('');
        $('#ToDate').val('');
        procedure_lists();
    });

    companyLists();
    vendorLists();
    iolCompanyLists();
    var FromDate = $('#FromDate').val();
    var ToDate = $('#ToDate').val();
    procedure_lists(FromDate, ToDate);

    $('#add_button').click(function() {
        var CurrDate = $('#CurrDate').val();
        $('.modal-title').html("Add <span class='font-weight-light'>New Lense</span>");
        $('#action').val("Save");
        $('#id').val('');

        $('#Cname').val('');
        $('#Model').val('');
        $('#Power').val('');
        $('#ExpMonth').val('').attr("selected", true);
        $('#ExpYear').val('');
        $('#StockDate').val(CurrDate);
        $('#Quantity').val('');
        $('#Narration').val('');
        $('#TransType').val('');
        $('#SrNo').val('');
        $('#BillNo').val('');
        $('#BillDate').val('');
        $('#VedName').val('');
        $('#IolCompName').val('');
        $('#Amount').val('');
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveLense') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    console.log(data);
                    if (data == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        procedure_lists(FromDate, ToDate);
                        companyLists();

                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
        }
    });

    $(document).on("click", ".update", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        var FromDate = $('#FromDate').val();
    var ToDate = $('#ToDate').val();
        var action = "fetch_record";
        $.ajax({
            url: "{{ url('editLense') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: id
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
                $('#VedName').val(data.VedName);
                $('#IolCompName').val(data.IolCompName);
                $('#Cname').val(data.Cname);
                $('#Model').val(data.Model);
                $('#Power').val(data.Power);
                $('#ExpMonth').val(data.ExpMonth).attr("selected", true);
                $('#ExpYear').val(data.ExpYear);
                $('#StockDate').val(data.StockDate);
                $('#Quantity').val(data.Quantity);
                $('#Narration').val(data.Narration);
                $('#TransType').val(data.TransType);
                $('#SrNo').val(data.SrNo);
                $('#BillNo').val(data.BillNo);
                $('#BillDate').val(data.BillDate);
                $('#Amount').val(data.Amount);
                $('#action').val('Edit');

                $('#id').val(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Lense</span>");
                    companyLists();

    procedure_lists(FromDate, ToDate);


            }
        });
    });



    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        var FromDate = $('#FromDate').val();
    var ToDate = $('#ToDate').val();
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Lense!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteLense') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        swal("Deleted!", "Lense has been deleted.", "success");

                      
                        companyLists();

procedure_lists(FromDate, ToDate);

                    }
                });

            } else {
                swal("Cancelled", "Lense is safe :)", "error");
            }
        });


    });

});
</script>
