@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Treatment Package Master</h4>
    <form id="validation-form" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-12 mb-4">

                <div id="accordion">
                    <div class="card mb-2">


                        <div class="card-body demo-vertical-spacing">


                            <div class="table-responsive" style="overflow-x:auto;">

                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td width="13%">Package Name </td>
                                        <td width="25%"><input class="form-control" type="text" list="emails2"
                                                style="overflow-x:auto;" name="PackageName" id="PackageName" required
                                                onchange="getPackageDetails(this.value)">
                                            <datalist id="emails2">

                                            </datalist>
                                        </td>
                                        <td width="14%">Package Amount </td>
                                        <td width="11%"><input type="text" class="form-control" id="PackageAmt"
                                                placeholder="" name="PackageAmt" onKeyPress="return isNumberKey(event)"
                                                required=""></td>
                                        <td width="12%">Balance Amount </td>
                                        <td width="25%"><input type="text" class="form-control" id="BalanceAmt"
                                                name="BalanceAmt" placeholder="" onKeyPress="return isNumberKey(event)"
                                                required="" value="0"></td>
                                    </tr>
                                </table>


                            </div>




                        </div>

                    </div>



                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-md-12 mb-4">

                <div id="accordion">
                    <div class="card mb-2">


                        <div class="card-body demo-vertical-spacing">


                            <div class="row">
                                <input type="hidden" name="action" id="action" value="Save">
                                <input type="hidden" name="id" id="id" />

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Charges Name <span
                                                class="text-danger">*</span></label>
                                        <input class="form-control" type="text" name="Name" id="Name" required="">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Day/Unit <span
                                                class="text-danger">*</span></label>
                                        <input class="form-control" type="text" name="Days" id="Days" required=""
                                            onKeyPress="return isNumberKey(event)"
                                            oninput="getAmount(document.getElementById('Days').value,document.getElementById('Rate').value)">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Rate <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="Rate" id="Rate" placeholder=""
                                            onKeyPress="return isNumberKey(event)" required=""
                                            oninput="getAmount(document.getElementById('Days').value,document.getElementById('Rate').value)">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="floating-label" for="Name">Amount <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="Amount" id="Amount" placeholder=""
                                            onKeyPress="return isNumberKey(event)" required="" readonly>
                                    </div>
                                </div>

                                <div class="col-sm-2" style="padding-top:20px;">
                                    <button class="btn btn-success btn-sm mb-3 btn-round" type="submit" name="submit"
                                        id="submit"><i class="feather icon-plus"></i> Add</button>
                                    <a href="/packagemaster" class="btn btn-danger btn-sm mb-3 btn-round"><i
                                            class="feather icon-reload"></i>
                                        Refresh</a>
                                </div>
                            </div>
                            <div class="table-responsive" id="custresult">

                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>



    </form>



</div>
@include('footerscript')
<script>
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Package Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Package Name Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function getAmount(days, rate) {
    var Amount = Number(days) * Number(rate);
    $('#Amount').val(Amount);
}

function calBalanceAmt(PackageName) {
    
    var action = 'calBalanceAmt';
    $.ajax({
        url: "{{ url('calBalanceAmt') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            PackageName: PackageName
        },
        success: function(data) {
            //console.log(data);
            $('#BalanceAmt').val(data);
        }
    });
}

function getPackageDetails(val) {
    var action = 'getPackageDetails';
    $.ajax({
        url: "{{ url('getPackageDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            PackageName: val
        },
        dataType: "json",
        success: function(data) {
            //console.log(data);
            $('#PackageAmt').val(data.PackageAmt);
            //$('#BalanceAmt').val(data.BalanceAmt);
            procedure_lists(val);
            calBalanceAmt(val);
        }
    });
}

function procedure_lists(PackageName) {
    var action = 'view';
    //var PackageName = $('#PackageName').val();
    $.ajax({
        url: "{{ url('viewPackageList') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            PackageName: PackageName
        },
        success: function(data) {
           // console.log(data);
            $('#custresult').html(data);
        }
    });
}

$(document).ready(function() {
    var PackageName = $('#PackageName').val();
    procedure_lists(PackageName);
    calBalanceAmt(PackageName);

    $('#add_button').click(function() {
        $('.modal-title').html("Add <span class='font-weight-light'>New Charges</span>");
        $('#action').val("Save");
        $('#id').val('');

        $('#Name').val('');
        $('#Amount').val('');
        $('#Rate').val('');
        $('#Days').val('');
        $('#submit').text('Add');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        var PackageName = $('#PackageName').val();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('savePackage') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                success: function(data) {
                    //console.log(data);
                    if (data == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        procedure_lists(PackageName);
                        calBalanceAmt(PackageName);
                        $('#Name').val('');
                        $('#Amount').val('');
                        $('#Rate').val('');
                        $('#Days').val('');
                        $('#action').val('Save');

                        $('#id').val('');
                        $('#submit').text("Add");
                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Add');
                }
            });
        }
    });

    $(document).on("click", ".update", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        var action = "fetch_record";

        $.ajax({
            url: "{{ url('editPackage') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: id
            },
            dataType: "json",
            success: function(data) {
                $('#Name').val(data.Name);
                $('#Days').val(data.Days);
                $('#Rate').val(data.Rate);
                $('#Amount').val(data.Amount);
                $('#action').val('Edit');

                $('#id').val(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Charges</span>");

            }
        });
    });

    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        var PackageName = $('#PackageName').val();
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Charges!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteCharge') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },
                    success: function(data) {
                        console.log(data);
                        swal("Deleted!", "Charges has been deleted.", "success");

                        procedure_lists(PackageName);
                        calBalanceAmt(PackageName);

                    }
                });

            } else {
                swal("Cancelled", "Charges is safe :)", "error");
            }
        });


    });


});
</script>
