@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Consent Master</h4>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center m-l-0">

                        

                        <div class="col-sm-2 text-left">
                            <a href="addConsent" class="btn btn-success btn-sm mb-3 btn-round"><i class="feather icon-plus"></i> Add
                                Consent</a>
                        </div>


                    </div>
                    <hr>
                    <div class="table-responsive" id="custresult">
                        <table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                            <thead>
                            <tr>
                                 <th>Sr.No</th>
                                 <th>File Name</th>
                                 <th>Title</th>
                                 <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $i=1;@endphp
                                @foreach($data as $result)
                            <tr>
                                <td>{{$i}}</td>
                                <td>{{$result->Name}} {{$result->Language}}</td>
                                <td>{{$result->Title}}</td>
                                <td><a href='editConsent/{{$result->id}}' data-toggle="tooltip" data-placement="top"
                                    title="Edit" data-original-title="Edit"><i
                                        class="lnr lnr-pencil mr-2"></i></a>&nbsp;&nbsp;
                                <a data-id="{{$result->id}}" href='javascript:void(0);' data-toggle="tooltip" data-placement="top"
                                    title="Delete" data-original-title="Delete" class="delete"><i
                                        class="lnr lnr-trash text-danger"></i></a>
                            </td>
                            </tr>
                            @php $i++;@endphp
                                @endforeach
                            </tbody>
                    </div>
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>




</div>

@include('footerscript')
<script>
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Package Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Package Name Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}



$(document).ready(function() {

    $('#example').DataTable( {
    responsive: true
  });



    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Consent!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $('.btn-danger').attr('disabled','disabled');
                $('.btn-danger').text('...');
                $.ajax({
                    url: "{{ url('deleteConsent') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        setTimeout(function() {
        swal({
            title: "Deleted!",
            text: "Consent has been deleted.",
            type: "success"
        }, function() {
            window.location = "/consent";
        });
    }, 1000);
       
                        

                    }
                });

            } else {
                swal("Cancelled", "Consent is safe :)", "error");
            }
        });


    });

});
</script>
