@extends('layout')

@section('content')

<style type="text/css">
fieldset legend {
    background: inherit;
    font-family: "Lato", sans-serif;
    color: #650812;
    font-size: 15px;
    left: 10px;
    padding: 0 10px;
    position: absolute;
    top: -12px;
    font-weight: 400;
    width: auto !important;
    border: none !important;
}

fieldset {
    background: #ffffff;
    border: 1px solid #C43853;
    border-radius: 5px;
    margin: 20px 0 1px 0;
    padding: 25px;
    position: relative;
}

.form-control {
    min-height: 1px;
    height: 25px;
}

.table th,
.table td {
    padding: 0.325rem;
}
</style>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Counselling</h4>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">

                <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data"
                    autocomplete="off" action="/{{projectUrl()}}saveCounselling">
                        <input type="hidden" name="action" id="action" value="Save">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-6" style="margin-bottom: 0rem;">
                                <label class="floating-label" for="Name">Search Old Patients <span
                                        class="text-danger">*</span></label>
                                <input class="form-control" list="DataList" name="PatientId" id="PatientId">
                                <datalist id="DataList">
                                    @foreach($patientList as $result)
                                    @if($result->Phone == '')
                                    <?php $PatientName = $result->MrdNo." / ".$result->PatientName;?>
                                    @else
                                    <?php $PatientName = $result->MrdNo." / ".$result->PatientName."/".$result->Phone;?>
                                    @endif
                                    <option value="{{$PatientName}}">
                                        @endforeach
                                </datalist>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="floating-label" for="Name">Search Counselling Id's </label>
                                <input class="form-control" list="DataList2" name="CounsId" id="CounsId"
                                    oninput="getCounselDetails()">
                                <datalist id="DataList2">
                                    @foreach($counsellingid as $result)

                                    <option value="{{$result->id}}">
                                        @endforeach

                                </datalist>


                            </div>
                        </div>
                        <div class="form-row align-items-center">
                            <div class="table-responsive">
                                <table id="report-table" class="table table-bordered table-striped mb-0">
                                    <tbody>
                                        <tr>
                                            <td width="10">ID<br>
                                                <input name="id" type="text" class="form-control" id="id" value=""
                                                    size="10" readonly placeholder="">
                                            </td>
                                            <td width="20">Mrd.No<br>
                                                <input name="MrdNo" type="text" class="form-control" id="MrdNo" value=""
                                                    size="10" readonly placeholder="">
                                            </td>
                                            <td width="110">Name<br>
                                                <input type="text" name="PatientName" id="PatientName"
                                                    class="form-control" placeholder="" value="" readonly>
                                            </td>
                                            <td width="25">Age<br>
                                                <input name="Age" type="text" id="Age" class="form-control" value=""
                                                    size="10" readonly placeholder="">
                                            </td>
                                            <td width="10">Gender<br>
                                                <input name="Gender" type="text" id="Gender" class="form-control"
                                                    value="" size="10" readonly placeholder="">
                                            </td>
                                            <td width="15">Mobile No <br>
                                                <input type="text" name="Phone" id="Phone" class="form-control" value=""
                                                    placeholder="" readonly>
                                            </td>
                                            <td width="25">Address <br>
                                                <input type="text" name="Address" id="Address" class="form-control"
                                                    value="" placeholder="" readonly>
                                            </td>
                                            <td width="25">City<br>
                                                <input type="text" name="City" id="City" class="form-control" value=""
                                                    placeholder="" readonly>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>

                        </div>
                        <div class="form-group col-md-12"
                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">
                            <fieldset>
                                <legend>Counselling</legend>
                                <div class="table-responsive" style="overflow-x:auto;">
                                    <table id="report-table" class="table table-bordered table-striped mb-0">
                                        <thead>
                                            <tr>
                                                <td width="144" align="left" valign="top">Admission Date </td>
                                                <td width="277" align="left" valign="top">
                                                    <input type="date" class="form-control" name="AdmissionDate"
                                                        id="AdmissionDate" required value="2022-05-19">
                                                </td>
                                                <td width="86" align="left" valign="top">Counselling Date </td>
                                                <td width="161" align="left" valign="top"><input type="date"
                                                        class="form-control" name="CounsellingDate" id="CounsellingDate"
                                                        required value="2022-05-19" /></td>
                                                <td width="157" align="left" valign="top">Surgery Date </td>
                                                <td width="144" align="left" valign="top"><input type="date"
                                                        class="form-control" name="SurgeryDate" id="SurgeryDate"
                                                        value="2022-05-19" required /></td>
                                                <td width="104" align="left" valign="top">Site</td>
                                                <td width="144" align="left" valign="top">
                                                <select
                                                                                class="form-control" name="Site"
                                                                                id="Site" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE"
                                                                                    >RE
                                                                                </option>
                                                                                <option value="LE"
                                                                                    >LE
                                                                                </option>
                                                                                <option value="BE"
                                                                                    >BE
                                                                                </option>
                                                                            </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="8" align="left" valign="top">
                                                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                        <tr>
                                                            <td width="155" rowspan="2" align="left" valign="top">
                                                                Diagnosis<br>
                                                                <button class="btn btn-secondary" type="button"
                                                                    data-toggle="modal" data-target="#modal-report"
                                                                    id="add_button"
                                                                    onclick="getValue('Diagnosis','Diagnosis')">...</button>
                                                            </td>
                                                            <td width="276" rowspan="2">

                                                                <textarea name="Diagnosis" cols="35" rows="4"
                                                                    class="form-control" id="Diagnosis"></textarea>

                                                            </td>
                                                            <td width="98" rowspan="2" align="left" valign="top">Surgery
                                                                Name <br>
                                                                <button class="btn btn-secondary" type="button"
                                                                    data-toggle="modal" data-target="#modal-report"
                                                                    id="add_button"
                                                                    onclick="getValue('SurgeryName','SurgeryName')">...</button>
                                                            </td>
                                                            <td width="325" rowspan="2" align="left" valign="top">
                                                                <textarea name="SurgeryName" cols="45" rows="4"
                                                                    class="form-control" id="SurgeryName"></textarea>
                                                            </td>
                                                            <td width="201" align="left" valign="top">Surgeon Name </td>
                                                            <td width="202" align="left" valign="top"><input
                                                                    class="form-control" list="DataList5"
                                                                    name="SurgenName" id="SurgenName" value="" />

                                                                <datalist id="DataList5">
                                                                @foreach($consultantList as $result)
                                                                    <option value="{{$result->Name}}">
                                                                    @endforeach
                                                             

                                                                </datalist>

                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td align="left" valign="top">Anaesthetist</td>
                                                            <td align="left" valign="top"><input class="form-control"
                                                                    name="Anaesthetist" id="Anaesthetist" value="" />
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td align="left" valign="top" colspan="2">
                                                    <button  name="submit" type="submit" id="submit" class="btn btn-primary btn-finish">Save</button>
                                                        <button type="button" 
                                                        class="btn btn-primary btn-finish" onclick="refresh()">Refresh</button>
                                                    <button type="button" id="delete" onclick="deleteRecord()"
                                                        class="btn btn-primary btn-finish" disabled>Delete</button>
                                                    <button type="button" class="btn btn-primary btn-finish"
                                                        onclick="showList()">Show
                                                        List</button>
                                                  
                                                </td>

                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </fieldset>
                        </div>

                    </form>

                    <input type="hidden" id="CurrDate" value="2022-05-19">
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>



</div>
@endsection
<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/inccommonmodal')
@section('scriptcontent')
<script type="text/javascript">

    function showList(){
        setTimeout(function() {
            window.open(
                '/{{projectUrl()}}viewCounsellings', 'popUpWindow1',
                'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
    function getLastCounsellingId(){
        $.ajax({
            url: "{{ url('getLastCounsellingId') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}'
            },
            success: function(data) {
                $('#id').val(data);
            }
        });
    }

    function getValue(val, idval) {
        $('#ModalValue').val(val);
        $('#ValueId').val(idval);
        $('#OldValue').val('');
        desc_lists(val);
    }

    function refresh(){
        $('#CounsId').val('');
        blankForm();
    }
    function blankForm(){
        getLastCounsellingId();
               
                $('#MrdNo').val('');
                $('#PatientName').val('');
                $('#Age').val('');
                $('#Phone').val('');
                $('#Gender').val('').attr("selected", "selected");
                $('#Address').val('');
                $('#City').val('');
                $('#Diagnosis').val('');
                $('#SurgeryName').val('');
                $('#SurgenName').val('').attr("selected", "selected");
                $('#Anaesthetist').val('');
                $('#AdmissionDate').val('');
                $('#CounsellingDate').val('');
                $('#SurgeryDate').val('');
                $('#action').val('Save');
                $('#delete').attr('disabled',true);
    }
    function getCounselDetails(val){
        $.ajax({
            url: "{{ url('fetchCounsellingDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            dataType: "json",
            success: function(data) {
                $('#id').val(data.id);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Age').val(data.Age);
                $('#Phone').val(data.Phone);
                $('#Gender').val(data.Gender).attr("selected", "selected");
                $('#Address').val(data.Address);
                $('#City').val(data.City);
                $('#Site').val(data.Site).attr("selected", "selected");
                $('#AdmissionDate').val(data.AdmissionDate);
                $('#CounsellingDate').val(data.CounsellingDate);
                $('#SurgeryDate').val(data.SurgeryDate);
                $('#Diagnosis').val(data.Diagnosis);
                $('#SurgeryName').val(data.SurgeryName);
                $('#SurgenName').val(data.SurgenName).attr("selected", "selected");
                $('#Anaesthetist').val(data.Anaesthetist);
                $('#action').val('Edit');
                $('#delete').attr('disabled',false);
              
            }
        });
    }

    function deleteRecord(){
        var id = $('#id').val();
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Record!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deletCounselling') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },
                    beforeSend:function(){
                $('.confirm').attr('disabled','disabled');
                $('.confirm').text('Please Wait...');
                },

                    success: function(data) {
                       
                        swal("Deleted!", "Record has been deleted.", "success");
                        //window.location.href = "/queuemanagement";
                        blankForm();



                    }
                });

            } else {
                swal("Cancelled", "Record is safe :)", "error");
            }
        });
    }
$(document).ready(function() {
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        alert("ok");
      
    });
    
    getLastCounsellingId();
    $(document).on("change", "#PatientId", function(event) {
        var val = this.value;
        $.ajax({
            url: "{{ url('getPatientDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
              
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Age').val(data.Age);
                $('#Phone').val(data.Phone);
                $('#Gender').val(data.Gender).attr("selected", "selected");
                $('#Address').val(data.Address);
                $('#City').val(data.City);
                //$('#PartStateId').html(data);
            }
        });

    });

    $(document).on("change", "#CounsId", function(event) {
        var val = this.value;
        if(val == ''){
            blankForm()
        }
        else{
        getCounselDetails(val);
        }
    });

    $(document).on("input", "#CounsId", function(event) {
        var val = this.value;
        if(val == ''){
            blankForm()
        }
        else{
        getCounselDetails(val);
        }

    });


  
});
</script>
@endsection