{{authUser()}}
<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 20px 0 1px 0;
        padding: 25px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
    }
    </style>
</head>
<?php 
 if(file_exists('json_files/json-file.json')){ 
    $json = file_get_contents('json_files/json-file.json');
    //Decode JSON
    $json_data = json_decode($json,true);
    $results = array();
    }
?>

<body>
    <div class="layout-wrapper layout-1 layout-without-sidenav">
        <div class="layout-inner">
            <div class="layout-container">
                <!-- [ Layout content ] Start -->
                <div class="container-fluid flex-grow-1">
                    <div class="form-row align-items-center">
                        <div class="table-responsive">
                            <table id="report-table" class="table table-bordered table-striped mb-0">
                                <tbody>
                                    <tr>
                                        <td width="47">Mrd.No 1<br><input type="text" id="MrdNo" class="form-control"
                                                placeholder="" value="{{$MrdNo}}" readonly="readonly"></td>
                                        <td width="110">Name<br><input type="text" class="form-control" placeholder=""
                                                value="{{$ptdata[0]->PatientName}}" readonly="readonly"></td>
                                        <td width="25">Age<br><input type="text" class="form-control" placeholder=""
                                                value="{{$ptdata[0]->Age}}" readonly="readonly"></td>
                                        <td width="25">Gender<br><input type="text" class="form-control" placeholder=""
                                                value="{{$ptdata[0]->Gender}}" readonly="readonly"></td>
                                        <td width="15">Visit No<br><input type="text" class="form-control"
                                                value="{{$VisitNo}}" placeholder="" readonly="readonly"></td>
                                        <td width="25">Visit Date<br><input type="date" class="form-control"
                                                placeholder="" value="{{$VisitDate}}" readonly="readonly"></td>
                                        <td width="70"><select class="form-control" data-style="btn-primary"
                                                onchange="getConsultRec(this.value)"
                                                style="min-height: 10px;height: 46px">
                                                <option selected="">Visits</option>@foreach($visitList as $result)
                                                <option value="{{$result->VisitDate}}"
                                                    <?php if($result->VisitDate == $VisitDate) {?> selected="selected"
                                                    <?php } ?>>{{$result->VisitNo}} /
                                                    {{date('d/m/Y', strtotime($result->VisitDate))}}</option>@endforeach
                                            </select></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-2">
                                <div class="card-body" style="padding: 1px;padding-left: 6px;padding-right: 6px">
                                    <div class="card-header" style="padding-top: 5px">
                                        <ul class="nav nav-tabs card-header-tabs nav-responsive-md">
                                            <li class="nav-item"><a class="nav-link active" data-toggle="tab"
                                                    href="#navs-wc-home" onclick="pressTab(1)">Optometrist</a></li>
                                            <li class="nav-item"><a class="nav-link" data-toggle="tab"
                                                    href="#navs-wc-profile" onclick="pressTab(2)">Consultant</a></li>
                                            <li class="nav-item"><a class="nav-link" data-toggle="tab"
                                                    href="#navs-wc-summary" onclick="pressTab(3)">OPD Summary</a></li>
                                        </ul>
                                    </div>
                                    <div class="tab-content">
                                        <div class="tab-pane fade show active" id="navs-wc-home">
                                            <form method="post" action="/saveOpto"
                                                autocomplete="off"><input type="hidden" name="action" id="action"
                                                    value="Save"> <input type="hidden" name="id" id="id" value="">
                                                    @csrf
                                                <input type="hidden" name="MrdNo" id="MrdNo" class="form-control"
                                                    placeholder="" value="{{$MrdNo}}" readonly="readonly"> <input
                                                    type="hidden" name="PatientName" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->PatientName}}" readonly="readonly"> <input
                                                    type="hidden" name="Age" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->Age}}" readonly="readonly"> <input
                                                    type="hidden" name="Gender" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->Gender}}" readonly="readonly"> <input
                                                    type="hidden" name="VisitNo" class="form-control"
                                                    value="{{$VisitNo}}" placeholder="" readonly="readonly"> <input
                                                    type="hidden" name="VisitDate" class="form-control" placeholder=""
                                                    value="{{$VisitDate}}" readonly="readonly">
                                                <div class="form-row">
                                                    <div class="form-group col-md-7" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Presenting Complaints</legend>
                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <div class="row">
                                                                        <div class="col-lg-11"><textarea
                                                                                class="form-control" id="Complaint1"
                                                                                name="Complaint1"
                                                                                style="height: 39px"></textarea></div>
                                                                        <div class="col-lg-1"><span
                                                                                class="input-group-append"><button
                                                                                    class="btn btn-secondary"
                                                                                    type="button" data-toggle="modal"
                                                                                    data-target="#modal-report"
                                                                                    id="add_button"
                                                                                    onclick="getValue('Complaint','Complaint1')">...</button></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"
                                                                            style="padding-left: 30px"><select
                                                                                class="form-control" name="CompDays1"
                                                                                id="CompDays1" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>@foreach($compDays as $result)
                                                                                <option value="{{$result->Name}}" >
                                                                                    {{$result->Name}}</option>
                                                                                @endforeach
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"><select
                                                                                class="form-control" name="CompEyes1"
                                                                                id="CompEyes1" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >RE</option>
                                                                                <option value="LE" >LE</option>
                                                                                <option value="BE" >BE</option>
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                            </div><br>
                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <div class="row">
                                                                        <div class="col-lg-11"><textarea
                                                                                class="form-control" id="Complaint2"
                                                                                name="Complaint2"
                                                                                style="height: 39px"></textarea></div>
                                                                        <div class="col-lg-1"><span
                                                                                class="input-group-append"><button
                                                                                    class="btn btn-secondary"
                                                                                    type="button" data-toggle="modal"
                                                                                    data-target="#modal-report"
                                                                                    id="add_button"
                                                                                    onclick="getValue('Complaint','Complaint2')">...</button></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"
                                                                            style="padding-left: 30px"><select
                                                                                class="form-control" name="CompDays2"
                                                                                id="CompDays2" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>@foreach($compDays as $result)
                                                                                <option value="{{$result->Name}}" >
                                                                                    {{$result->Name}}</option>
                                                                                @endforeach
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"><select
                                                                                class="form-control" name="CompEyes2"
                                                                                id="CompEyes2" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >RE</option>
                                                                                <option value="LE" >LE</option>
                                                                                <option value="BE" >BE</option>
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                            </div><br>
                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <div class="row">
                                                                        <div class="col-lg-11"><textarea
                                                                                class="form-control" id="Complaint3"
                                                                                name="Complaint3"
                                                                                style="height: 39px"></textarea></div>
                                                                        <div class="col-lg-1"><span
                                                                                class="input-group-append"><button
                                                                                    class="btn btn-secondary"
                                                                                    type="button" data-toggle="modal"
                                                                                    data-target="#modal-report"
                                                                                    id="add_button"
                                                                                    onclick="getValue('Complaint','Complaint3')">...</button></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"
                                                                            style="padding-left: 30px"><select
                                                                                class="form-control" name="CompDays3"
                                                                                id="CompDays3" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>@foreach($compDays as $result)
                                                                                <option value="{{$result->Name}}" >
                                                                                    {{$result->Name}}</option>
                                                                                @endforeach
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <div class="row">
                                                                        <div class="col-lg-12"><select
                                                                                class="form-control" name="CompEyes3"
                                                                                id="CompEyes3" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >RE</option>
                                                                                <option value="LE" >LE</option>
                                                                                <option value="BE" >BE</option>
                                                                            </select></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <table width="700"
                                                                        class="table table-bordered table-striped mb-0"
                                                                        id="report-table">
                                                                        <tbody>
                                                                            <tr>
                                                                                <td width="141" align="left"
                                                                                    valign="top">Past Ocular History
                                                                                </td>
                                                                                <td width="547"><textarea
                                                                                        class="form-control"
                                                                                        id="PastHistory" rows="2"
                                                                                        name="PastHistory"
                                                                                        style="height: 36px"></textarea>
                                                                                </td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-5" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Medical History</legend>
                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <table width="723"
                                                                        class="table table-bordered table-striped mb-0"
                                                                        id="report-table">
                                                                        <thead>
                                                                            <tr>
                                                                                <th width="113"><input type="checkbox"
                                                                                        value="DM" name="ChkDm" > DM</th>
                                                                                <th width="128"><input type="checkbox"
                                                                                        value="HT" name="ChkHt" > HT</th>
                                                                                <th width="109"><input type="checkbox"
                                                                                        value="C.A.D" name="ChkCad" >
                                                                                    C.A.D</th>
                                                                                <th width="146"><input type="checkbox"
                                                                                        value="Prost." name="ChkProst" >
                                                                                    Prostate</th>
                                                                                <th width="88"><input type="checkbox"
                                                                                        value="COPD" name="ChkCopd" >
                                                                                    C.O.P.D</th>
                                                                                <th width="111"><input type="checkbox"
                                                                                        name="ChkOther" value="Other" >
                                                                                    Others</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr>
                                                                                <td><input class="form-control"
                                                                                        name="DmFrom" id="dmtext"
                                                                                        value=""></td>
                                                                                <td><input class="form-control"
                                                                                        name="HtFrom" id="dmtext2"
                                                                                        value=""></td>
                                                                                <td><input class="form-control"
                                                                                        name="CadFrom" id="dmtext5"
                                                                                        value=""></td>
                                                                                <td><input class="form-control"
                                                                                        name="ProstFrom" id="dmtext3"
                                                                                        value=""></td>
                                                                                <td><input class="form-control"
                                                                                        name="CopdFrom" id="dmtext4"
                                                                                        value=""></td>
                                                                                <td><input class="form-control"
                                                                                        name="OtherFrom" id="dmtext6"
                                                                                        value=""></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="DmPeriod"
                                                                                id="DmPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>    
                                                                               </td>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="HtPeriod"
                                                                                id="HtPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>       
                                                                               </td>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="CadPeriod"
                                                                                id="CadPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>    
                                                                               </td>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="ProstPeriod"
                                                                                id="ProstPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>       
                                                                               </td>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="CopdPeriod"
                                                                                id="CopdPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>    
                                                                                </td>
                                                                                <td>
                                                                                <select
                                                                                class="form-control" name="OtherPeriod"
                                                                                id="OtherPeriod" style="height: 31px">
                                                                                <option selected="" value="">...
                                                                                </option>
                                                                                <option value="RE" >Days</option>
                                                                                <option value="LE" >Months</option>
                                                                                <option value="BE" >Years</option>
                                                                                </select>    
                                                                                  </td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <table width="700"
                                                                        class="table table-bordered table-striped mb-0"
                                                                        id="report-table">
                                                                        <thead>
                                                                            <tr>
                                                                                <th width="167">Addictions</th>
                                                                                <th width="217">Allergy History</th>
                                                                                <th width="300">Medical Ocular History
                                                                                </th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr>
                                                                                <td><textarea class="form-control"
                                                                                        id="Addictions" rows="2"
                                                                                        name="Addictions"></textarea>
                                                                                </td>
                                                                                <td><textarea class="form-control"
                                                                                        id="AllergyHistory" rows="2"
                                                                                        name="AllergyHistory"></textarea>
                                                                                </td>
                                                                                <td><textarea class="form-control"
                                                                                        id="MedicalHistory" rows="2"
                                                                                        name="MedicalHistory"></textarea>
                                                                                </td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-3" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Visual Actuity</legend>
                                                            <div class="table-responsive" style="overflow-x:auto">
                                                                <table id="report-table"
                                                                    class="table table-bordered table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <th width="10"></th>
                                                                            <th width="80">VA</th>
                                                                            <th width="80">VA WITH PH</th>
                                                                            <th width="80">OLD GLASSES</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>RE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="VaRe"
                                                                                    id="VaRe" value=""><datalist
                                                                                    id="DataList1">
                                                                                    <datalist id="DataList1">

                                                                                        <?php foreach($json_data['JsonData']['VA'] as $result) {?>
                                                                                        <option
                                                                                            value="{{$result['Values']}}">
                                                                                        <?php } ?>
                                                                                    </datalist>
                                                                                </datalist></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="VaPhRe"
                                                                                    id="VaPhRe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="OgRe"
                                                                                    id="OgRe" value=""></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>LE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="VaLe"
                                                                                    id="VaLe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="VaPhLe"
                                                                                    id="VaPhLe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList1" name="OgLe"
                                                                                    id="OgLe" value=""></td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-4" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Previous Glasses</legend>
                                                            <div class="table-responsive" style="overflow-x:auto">
                                                                <table id="report-table"
                                                                    class="table table-bordered table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <th width="10"></th>
                                                                            <th width="80">SPH</th>
                                                                            <th width="80">CYL</th>
                                                                            <th width="80">AXIS</th>
                                                                            <th width="80">NEAR ADD</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>RE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList2" name="PgSphRe"
                                                                                    id="PgSphRe" value=""><datalist
                                                                                    id="DataList2">
                                                                                    <?php
        foreach($json_data['JsonData']['SPH'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>
                                                                                </datalist></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList3" name="PgCylRe"
                                                                                    id="PgCylRe" value=""><datalist
                                                                                    id="DataList3">
                                                                                    <?php
        foreach($json_data['JsonData']['CYL'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>
                                                                                </datalist></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="PgAxisRe"
                                                                                    value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList4" name="PgNearAddRe"
                                                                                    id="PgNearAddRe" value=""><datalist
                                                                                    id="DataList4">
                                                                                    <?php
        foreach($json_data['JsonData']['NearAdd'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>
                                                                                </datalist></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>LE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList2" name="PgSphLe"
                                                                                    id="PgSphLe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList3" name="PgCylLe"
                                                                                    id="PgCylLe" value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="PgAxisLe"
                                                                                    value="">
                                                                                <div class="clearfix"></div>
                                                                            </td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList4" name="PgNearAddLe"
                                                                                    id="PgNearAddLe" value=""></td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-5" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Retinoscopy</legend>
                                                            <div class="table-responsive" style="overflow-x:auto">
                                                                <table id="report-table"
                                                                    class="table table-bordered table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <th width="10">RE</th>
                                                                            <th width="80"></th>
                                                                            <th width="80">AXIS</th>
                                                                            <th width="10">LE</th>
                                                                            <th width="80"></th>
                                                                            <th width="80">AXIS</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>HORZ</td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetHorzRe"
                                                                                    value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetHorzReAxis"
                                                                                    value=""></td>
                                                                            <td>HORZ</td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetHorzLe"
                                                                                    value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetHorzLeAxis"
                                                                                    value=""></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>VERT</td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetVertRe"
                                                                                    value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetVertReAxis"
                                                                                    value=""></td>
                                                                            <td>VERT</td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetVertLe"
                                                                                    value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="RetVertLeAxis"
                                                                                    value=""></td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-6" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Refraction</legend>
                                                            <div class="table-responsive" style="overflow-x:auto">
                                                                <table id="report-table"
                                                                    class="table table-bordered table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <th width="10"></th>
                                                                            <th width="80">SPH</th>
                                                                            <th width="80">CYL</th>
                                                                            <th width="80">AXIS</th>
                                                                            <th width="80">NEAR ADD</th>
                                                                            <th width="80">V.A With Glasses</th>
                                                                            <th width="80">N.V</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>RE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList2" name="SrSphRe"
                                                                                    id="SrSphRe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList3" name="SrCylRe"
                                                                                    id="SrCylRe" value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="SrAxisRe"
                                                                                    value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList4" name="SrNearAddRe"
                                                                                    id="SrNearAddRe" value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" list="DataList1"
                                                                                    name="SrVaGlassRe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="NvDataList" name="SrNvRe"
                                                                                    id="SrNvRe" value=""><datalist
                                                                                    id="NvDataList">
                                                                                    <?php
        foreach($json_data['JsonData']['NV'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>
                                                                                </datalist></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>LE</td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList4" name="SrSphLe"
                                                                                    id="SrSphLe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList3" name="SrCylLe"
                                                                                    id="SrCylLe" value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" name="SrAxisLe"
                                                                                    value="">
                                                                                <div class="clearfix"></div>
                                                                            </td>
                                                                            <td><input class="form-control"
                                                                                    list="DataList4" name="SrNearAddLe"
                                                                                    id="SrNearAddLe" value=""></td>
                                                                            <td><input type="text" class="form-control"
                                                                                    placeholder="" list="DataList1"
                                                                                    name="SrVaGlassLe" value=""></td>
                                                                            <td><input class="form-control"
                                                                                    list="NvDataList" name="SrNvLe"
                                                                                    id="SrNvLe" value=""></td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="form-group col-md-6" style="margin-bottom: 0rem">
                                                        <fieldset>
                                                            <legend>Glass Type / Uses / Remark</legend>
                                                            <div class="">
                                                                <table class="table table-bordered table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <td>Glass Type</td>
                                                                            <td><select
                                                                                    class="select2-demo form-control"
                                                                                    multiple="multiple"
                                                                                    style="width: 100%"
                                                                                    name="GlassType[]">
                                                                                    <?php
                        
                        foreach($json_data['JsonData']['GlassType'] as $result) {?>       
                           <option value="<?php echo $result['Values'];?>"><?php echo $result['Values'];?></option>
                                            <?php } ?>  
                                                                                </select></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>Uses</td>
                                                                            <td><select
                                                                                    class="select2-demo form-control"
                                                                                    multiple="multiple"
                                                                                    style="width: 100%" name="Uses[]">
                                                                                    <?php
   
   foreach($json_data['JsonData']['Uses'] as $result) {?>       
      <option value="<?php echo $result['Values'];?>"><?php echo $result['Values'];?></option>
                       <?php } ?>  
                                                                                </select></td>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>Remark</td>
                                                                            <td><textarea class="form-control"
                                                                                    id="Address"
                                                                                    name="Remarks"></textarea></td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-12 sub_btn" style="padding-top:10px"><button
                                                            class="btn btn-primary" type="submit"
                                                            name="submit">Submit</button> <button class="btn btn-danger"
                                                            name="reset">Clear</button></div>
                                                </div>
                                            </form>
                                        </div><!-- Close Tab 1-->
                                        <!-- Open Tab 2 -->
                                        <div class="tab-pane fade" id="navs-wc-profile">
                                            <form method="post" action="/saveConsultant"
                                                autocomplete="off">
                                                <input type="hidden" name="action" id="action"
                                                    value="Save"> <input type="hidden" name="id" id="id" value="">
                                                    @csrf
                                                <input type="hidden" name="MrdNo" id="MrdNo" class="form-control"
                                                    placeholder="" value="{{$MrdNo}}" readonly="readonly"> <input
                                                    type="hidden" name="PatientName" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->PatientName}}" readonly="readonly"> <input
                                                    type="hidden" name="Age" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->Age}}" readonly="readonly"> <input
                                                    type="hidden" name="Gender" class="form-control" placeholder=""
                                                    value="{{$ptdata[0]->Gender}}" readonly="readonly"> <input
                                                    type="hidden" name="VisitNo" class="form-control"
                                                    value="{{$VisitNo}}" placeholder="" readonly="readonly"> <input
                                                    type="hidden" name="VisitDate" class="form-control" placeholder=""
                                                    value="{{$VisitDate}}" readonly="readonly">
                                                <div class="form-row">
                                                    <div class="col-lg-5">
                                                        <div id="accordion">
                                                            <div class="card mb-2">
                                                                <div class="card-header"><a
                                                                        class="d-flex justify-content-between text-dark"
                                                                        data-toggle="collapse" aria-expanded="true"
                                                                        href="#accordion-1">DETAIL FINDINGS<div
                                                                            class="collapse-icon"></div></a></div>
                                                                <div id="accordion-1" class="collapse"
                                                                    data-parent="#accordion">
                                                                    <div class="table-responsive"
                                                                        style="overflow-x:auto">
                                                                        <table id="report-table"
                                                                            class="table table-bordered table-striped mb-0">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th width="5">&nbsp;</th>
                                                                                    <th width="250"><label
                                                                                            class="custom-control custom-checkbox"><input
                                                                                                type="checkbox"
                                                                                                class="custom-control-input"
                                                                                                value="1"
                                                                                                id="ChkReNormal"
                                                                                                name="ChkReNormal"
                                                                                                onclick="chkre_normal()">
                                                                                            <span
                                                                                                class="custom-control-label">RE
                                                                                                NORMAL</span></label>
                                                                                    </th>
                                                                                    <th width="250"><label
                                                                                            class="custom-control custom-checkbox"><input
                                                                                                type="checkbox"
                                                                                                class="custom-control-input"
                                                                                                value="1"
                                                                                                id="ChkLeNormal"
                                                                                                name="ChkLeNormal"
                                                                                                onclick="chkle_normal()">
                                                                                            <span
                                                                                                class="custom-control-label">LE
                                                                                                NORMAL</span></label>
                                                                                    </th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td>Ocular Movement</td>
                                                                                    <td><input class="form-control"
                                                                                            list="ocmre" name="ReOcMov"
                                                                                            id="ReOcMov"
                                                                                            value="">
                                                                                            <datalist id="ocmre">
                                                                <?php
        foreach($json_data['JsonData']['OcularMov'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                      
                                                        </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="ocmle" name="LeOcMov"
                                                                                            id="LeOcMov"
                                                                                            value=""><datalist id="ocmle">
                                                               <?php
        foreach($json_data['JsonData']['OcularMov'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                      
                                                                    </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Lids</td>
                                                                                    <td><input class="form-control"
                                                                                            list="lidsre" name="ReLids"
                                                                                            id="ReLids"
                                                                                            value=""><datalist id="lidsre">
                                                            <?php
        foreach($json_data['JsonData']['Lids'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                      
                                                                                                                              
                                                        </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="lidsle" name="LeLids"
                                                                                            id="LeLids"
                                                                                            value=""><datalist id="lidsle">
                                                      <?php
        foreach($json_data['JsonData']['Lids'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                                                                  
                                                        </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Conjunctiva</td>
                                                                                    <td><input class="form-control"
                                                                                            list="conjre" name="ReConj"
                                                                                            id="ReConj"
                                                                                            value=""><datalist id="conjre">
                                         <?php
        foreach($json_data['JsonData']['Conjunctiva'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                                    
                                                        </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="conjle" name="LeConj"
                                                                                            id="LeConj"
                                                                                            value=""><datalist id="conjle">
                                                           <?php
        foreach($json_data['JsonData']['Conjunctiva'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                                                   
                                                        </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Cornea</td>
                                                                                    <td><input class="form-control"
                                                                                            list="corre" name="ReCornea"
                                                                                            id="ReCornea"
                                                                                            value=""><datalist id="corre">
                                                           <?php
        foreach($json_data['JsonData']['Cornea'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
         </datalist>                    </td>
                                                                                    <td><input class="form-control"
                                                                                            list="corle" name="LeCornea"
                                                                                            id="LeCornea"
                                                                                            value=""><datalist id="corle">
                                                                 <?php
        foreach($json_data['JsonData']['Cornea'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Cornea Remark</td>
                                                                                    <td><textarea class="form-control"
                                                                                            id="ReCorneaRemark"
                                                                                            name="ReCorneaRemark"
                                                                                            rows="3"></textarea></td>
                                                                                    <td><textarea class="form-control"
                                                                                            id="LeCorneaRemark"
                                                                                            name="LeCorneaRemark"
                                                                                            rows="3"></textarea></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Ant. Chamber</td>
                                                                                    <td><input class="form-control"
                                                                                            list="antchbre"
                                                                                            name="ReAntChamber"
                                                                                            id="ReAntChamber"
                                                                                            value=""><datalist id="antchbre">
                                                                <?php
        foreach($json_data['JsonData']['AntChamber'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="antchble"
                                                                                            name="LeAntChamber"
                                                                                            id="LeAntChamber"
                                                                                            value=""><datalist id="antchble">
                                                                   <?php
        foreach($json_data['JsonData']['AntChamber'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Iris</td>
                                                                                    <td><input class="form-control"
                                                                                            list="irisre" name="ReIris"
                                                                                            id="ReIris"
                                                                                            value=""><datalist id="irisre">
                                                                 <?php
        foreach($json_data['JsonData']['Iris'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="irisle" name="LeIris"
                                                                                            id="LeIris"
                                                                                            value=""> <datalist id="irisle">
                                                                <?php
        foreach($json_data['JsonData']['Iris'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Pupil</td>
                                                                                    <td><input class="form-control"
                                                                                            list="pupilre"
                                                                                            name="RePupil" id="RePupil"
                                                                                            value=""><datalist id="pupilre">
                                                                <?php
        foreach($json_data['JsonData']['Pupil'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="pupille"
                                                                                            name="LePupil" id="LePupil"
                                                                                            value=""><datalist id="pupille">
                                                             <?php
        foreach($json_data['JsonData']['Pupil'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>IOP (AM / PM)</td>
                                                                                    <td><input type="text"
                                                                                            class="form-control"
                                                                                            placeholder="" name="ReIop"
                                                                                            value="">
                                                                                        <div class="clearfix"></div>
                                                                                    </td>
                                                                                    <td><input type="text"
                                                                                            class="form-control"
                                                                                            placeholder="" name="LeIop"
                                                                                            value="">
                                                                                        <div class="clearfix"></div>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Lens</td>
                                                                                    <td><input class="form-control"
                                                                                            list="lensre" name="ReLens"
                                                                                            id="ReLens"
                                                                                            value=""> <datalist id="lensre">
                                                                <?php
        foreach($json_data['JsonData']['Lens'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="lensle" name="LeLens"
                                                                                            id="LeLens"
                                                                                            value=""> <datalist id="lensle">
                                                               <?php
        foreach($json_data['JsonData']['Lens'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Lens 2</td>
                                                                                    <td><input class="form-control"
                                                                                            list="lensre2"
                                                                                            name="ReLens2" id="ReLens2"
                                                                                            value=""><datalist id="lensre2">
                                                                  <?php
        foreach($json_data['JsonData']['Lens2'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="lensle2"
                                                                                            name="LeLens2" id="LeLens2"
                                                                                            value=""><datalist id="lensle2">
                                                               <?php
        foreach($json_data['JsonData']['Lens2'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>NLP</td>
                                                                                    <td><input class="form-control"
                                                                                            list="NLPRE" name="ReNlp"
                                                                                            id="ReNlp"
                                                                                            value=""> <datalist id="NLPRE">
                                                               <?php
        foreach($json_data['JsonData']['NLP'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                    <td><input class="form-control"
                                                                                            list="NLPLE" name="LeNlp"
                                                                                            id="LeNlp"
                                                                                            value=""><datalist id="NLPLE">
                                                                <?php
        foreach($json_data['JsonData']['NLP'] as $result) {?>    
       <option value="<?php echo $result['Values']; ?>">
        <?php } ?>                      
 </datalist></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- <div class="form-group col-md-7" style="margin-bottom: 0rem;">
 <fieldset>
 <legend>Treatment</legend>
 <div class="row">
 
 </div> 
 </fieldset>
 </div> -->
                                                        <div class="form-group col-md-12" style="margin-bottom: 0rem">
                                                            <fieldset>
                                                                <legend>Investigation / User / Amount</legend>
                                                                <div class="row">
                                                                    <div class="form-group col-md-12"><input type="text"
                                                                            class="form-control"
                                                                            placeholder="Investigation Name"
                                                                            name="InvStName" value=""></div>
                                                                    <div class="form-group col-md-6"><input type="text"
                                                                            class="form-control" placeholder="Amount"
                                                                            name="Amount" value=""></div>
                                                                    <div class="form-group col-md-6"><input type="text"
                                                                            class="form-control" placeholder="User"
                                                                            name="InvStBy" value=""></div>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                        <div class="form-group col-md-12" style="margin-bottom: 0rem">
                                                            <fieldset>
                                                                <legend>Diagnosis</legend>
                                                                <div class="row">
                                                                    <div class="col-lg-10"><textarea
                                                                            class="form-control" id="Diagnosis"
                                                                            name="Diagnosis"></textarea></div>
                                                                    <div class="col-lg-1"><span
                                                                            class="input-group-append"><button
                                                                                class="btn btn-secondary" type="button"
                                                                                data-toggle="modal"
                                                                                data-target="#modal-report"
                                                                                id="add_button"
                                                                                onclick="getValue('Diagnosis','Diagnosis')">...</button></span>
                                                                    </div>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                        <div class="form-group col-md-12" style="margin-bottom: 0rem">
                                                            <fieldset>
                                                                <legend>Special Advice</legend>
                                                                <div class="row">
                                                                    <div class="col-lg-10"><textarea
                                                                            class="form-control" id="Advice"
                                                                            name="Advice"
                                                                            style="height: 40px"></textarea></div>
                                                                    <div class="col-lg-1"><span
                                                                            class="input-group-append"><button
                                                                                class="btn btn-secondary" type="button"
                                                                                data-toggle="modal"
                                                                                data-target="#modal-report"
                                                                                id="add_button"
                                                                                onclick="getValue('Advice','Advice')">...</button></span>
                                                                    </div>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                        <div class="form-group col-md-12" style="margin-bottom: 0rem">
                                                            <fieldset>
                                                                <legend>Remark</legend>
                                                                <div class="row">
                                                                    <div class="col-lg-10"><textarea
                                                                            class="form-control" id="Remark"
                                                                            name="Remark"
                                                                            style="height: 40px"></textarea></div>
                                                                    <div class="col-lg-1"><span
                                                                            class="input-group-append"><button
                                                                                class="btn btn-secondary" type="button"
                                                                                data-toggle="modal"
                                                                                data-target="#modal-report"
                                                                                id="add_button"
                                                                                onclick="getValue('Remark','Remark')">...</button></span>
                                                                    </div>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                        <div class="form-group col-md-12" style="margin-bottom: 0rem">
                                                            <fieldset>
                                                                <legend>Councelling Remark</legend>
                                                                <div class="row">
                                                                    <div class="col-lg-10"><textarea
                                                                            class="form-control" id="CouncRemark"
                                                                            name="CouncRemark"
                                                                            style="height: 40px"></textarea></div>
                                                                    <div class="col-lg-1"><span
                                                                            class="input-group-append"><button
                                                                                class="btn btn-secondary" type="button"
                                                                                data-toggle="modal"
                                                                                data-target="#modal-report"
                                                                                id="add_button"
                                                                                onclick="getValue('CouncRemark','CouncRemark')">...</button></span>
                                                                    </div>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-7">
                                                        <div id="accordion2">
                                                            <div class="card mb-2">
                                                                <div class="card-header"><a
                                                                        class="d-flex justify-content-between text-dark"
                                                                        data-toggle="collapse" aria-expanded="true"
                                                                        href="#accordion2-1">Fundus Examination<div
                                                                            class="collapse-icon"></div></a></div>
                                                                <div id="accordion2-1" class="collapse"
                                                                    data-parent="#accordion2">
                                                                    <div class="table-responsive"
                                                                        style="overflow-x:auto">
                                                                        <table id="report-table"
                                                                            class="table table-bordered table-striped mb-0">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th width="2">&nbsp;</th>
                                                                                    <th width="220"><label
                                                                                            class="custom-control custom-checkbox"><input
                                                                                                type="checkbox"
                                                                                                class="custom-control-input"
                                                                                                value="RE Hazy"
                                                                                                name="ChkReHazy"> <span
                                                                                                class="custom-control-label">RE</span></label>
                                                                                    </th>
                                                                                    <th width="220"><label
                                                                                            class="custom-control custom-checkbox"><input
                                                                                                type="checkbox"
                                                                                                class="custom-control-input"
                                                                                                value="LE Hazy"
                                                                                                name="ChkLeHazy"> <span
                                                                                                class="custom-control-label">LE</span></label>
                                                                                    </th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td>Media</td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="ReMedia"
                                                                                                        id="ReMedia"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('Media','ReMedia')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="LeMedia"
                                                                                                        id="LeMedia"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('Media','LeMedia')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Optic Disc</td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="ReOptDisc"
                                                                                                        id="ReOptDisc"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('OptDisc','ReOptDisc')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="LeOptDisc"
                                                                                                        id="LeOptDisc"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('OptDisc','LeOptDisc')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Macula and B.V</td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="ReMacBV"
                                                                                                        id="ReMacBV"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('MacBV','ReMacBV')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="LeMacBV"
                                                                                                        id="LeMacBV"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('MacBV','LeMacBV')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Midperiphery</td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="ReMidPerPh"
                                                                                                        id="ReMidPerPh"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('MidPerPh','ReMidPerPh')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div class="row">
                                                                                            <div class="col-lg-9">
                                                                                                <div class="form-group">
                                                                                                    <textarea
                                                                                                        class="form-control"
                                                                                                        placeholder="Search for..."
                                                                                                        name="LeMidPerPh"
                                                                                                        id="LeMidPerPh"> </textarea>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-lg-2"><span
                                                                                                    class="input-group-append"><button
                                                                                                        class="btn btn-secondary"
                                                                                                        type="button"
                                                                                                        data-toggle="modal"
                                                                                                        data-target="#modal-report"
                                                                                                        id="add_button"
                                                                                                        onclick="getValue('MidPerPh','LeMidPerPh')">...</button></span>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @include('opd/inctreatments')
                                                        <div class="col-md-12" style="padding: 15px"><label
                                                                class="custom-control custom-checkbox"><input
                                                                    type="checkbox" class="custom-control-input"
                                                                    value="1" name="Checked"> <span
                                                                    class="custom-control-label">Patient
                                                                    Checked</span></label></div>
                                                    </div>
                                                    <div class="col-sm-12 sub_btn" style="padding-top:10px"><button
                                                            class="btn btn-primary" type="submit"
                                                            name="submit">Submit</button> <a
                                                            href="#"
                                                            target="_blank" class="btn btn-success">OPD Detail Print</a>
                                                        <a href="#"
                                                            target="_blank" class="btn btn-success">OPD Brief Print</a>
                                                        <button class="btn btn-danger" name="reset">Clear</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="tab-pane fade" id="navs-wc-summary">
                                    @include('opd/opdpatientsummary')
                                    </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- [ Layout content ] Start -->
    <!-- [ Layout container ] End -->
    <!-- Overlay -->
    <div class="layout-overlay layout-sidenav-toggle"></div><!-- [ Layout wrapper] End -->
    <!-- Modal -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    @include('masters/inccommonmodal')
    @include('footerscript')
    

    <script>
       function getConsultRec(val){
    var MrdNo = $('#MrdNo').val();
    window.location.href="/optoform/"+MrdNo+"/"+val;
}  

function chkre_normal(){
    if($('#ChkReNormal').prop('checked') == true) {
       $('#ChkReNormal').val(1);
       $('#ReOcMov').val('Normal');
       $('#ReLids').val('Flat');
       $('#ReConj').val('Normal');
       $('#ReCornea').val('Bright and Clear');
       $('#ReAntChamber').val('Normal Depth');
       $('#ReIris').val('Colour and Pattern Normal');
       $('#RePupil').val('NSRL');
       $('#ReLens').val('Transparent');
       $('#ReNlp').val('No Regurgitation');
    }
    else{
       $('#ChkReNormal').val(0);
       $('#ReOcMov').val('');
       $('#ReLids').val('');
       $('#ReConj').val('');
       $('#ReCornea').val('');
       $('#ReAntChamber').val('');
       $('#ReIris').val('');
       $('#RePupil').val('');
       $('#ReLens').val('');
       $('#ReNlp').val('');
    }
}

function chkle_normal(){
    if($('#ChkLeNormal').prop('checked') == true) {
       $('#ChkLeNormal').val(1);
       $('#LeOcMov').val('Normal');
       $('#LeLids').val('Flat');
       $('#LeConj').val('Normal');
       $('#LeCornea').val('Bright and Clear');
       $('#LeAntChamber').val('Normal Depth');
       $('#LeIris').val('Colour and Pattern Normal');
       $('#LePupil').val('NSRL');
       $('#LeLens').val('Transparent');
       $('#LeNlp').val('No Regurgitation');
    }
    else{
       $('#ChkLeNormal').val(0);
       $('#LeOcMov').val('');
       $('#LeLids').val('');
       $('#LeConj').val('');
       $('#LeCornea').val('');
       $('#LeAntChamber').val('');
       $('#LeIris').val('');
       $('#LePupil').val('');
       $('#LeLens').val('');
       $('#LeNlp').val('');
    }
}

function getValue(val,idval){
    $('#ModalValue').val(val);  
    $('#ValueId').val(idval);
    $('#OldValue').val('');
    desc_lists(val);
}

function getRecords(val) {
        $.ajax({
            url: "{{ url('getTreatments') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                Treatment: val
            },
            success: function(data) {
                console.log(data);
                $('#showTreatments').html(data);
            }
        });
    }

    $(document).ready(function() {
        $(document).on("input", "#Treatment", function(event) {
            var val = $(this).val();
            getRecords(val);
        });     
    });   
</script>
</body>

</html>