<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')

</head>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Counsellings Lists</h4>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">

            <div class="card mb-4">
                <div class="card-body">
                    <div id="alert_message"></div>
                    <form id="validation-form22" method="post" enctype="multipart/form-data">
                        <div class="form-row">
                            <div class="form-group col-md-2">
                                <label class="form-label">From Date </label>
                                <input type="date" name="FromDate" id="FromDate" class="form-control" value=""
                                    autocomplete="off">
                            </div>
                            <div class="form-group col-md-2">
                                <label class="form-label">To Date</label>
                                <input type="date" name="ToDate" id="ToDate" class="form-control" value=""
                                    autocomplete="off">
                            </div>

                            <input type="hidden" name="Search" value="Search">
                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="button" id="filter" class="btn btn-primary btn-finish">Search</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-body">


                    <div class="table-responsive" id="custresult">


                    </div>
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>




</div>
@include('footerscript')
<script type="text/javascript">
$(document).ready(function() {
    //load_data();

    function load_data(FromDate = '', ToDate = '') {
        $.ajax({
            url: "{{ url('viewCounsellingList') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                FromDate: FromDate,
                ToDate: ToDate
            },
            success: function(data) {
                console.log(data);
                $('#custresult').html(data);
            }
        });
    }



    $('#filter').click(function() {
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        if (FromDate != '' && ToDate != '') {
            load_data(FromDate, ToDate);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh').click(function() {
        $('#FromDate').val('');
        $('#ToDate').val('');
        load_data();
    });


    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Record!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deletCounselling') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },
                    beforeSend: function() {
                        $('.confirm').attr('disabled', 'disabled');
                        $('.confirm').text('Please Wait...');
                    },

                    success: function(data) {

                        swal("Deleted!", "Record has been deleted.", "success");
                        //window.location.href = "/queuemanagement";
                        load_data();



                    }
                });

            } else {
                swal("Cancelled", "Record is safe :)", "error");
            }
        });


    });



});
</script>