<style>
    th { font-size: 20px; }
    .table-striped tbody tr:nth-of-type(odd) { background-color: #EFEFEF; }
    blink { font-size: 15px; font-weight: bold; }
</style>

<table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
    <thead>
        <tr style="background-color: rgb(65, 110, 110); color: white;">
            <th>Action</th>
            <th>Sr.No</th>
            <th>MRD No</th>
            <th>Name</th>
            <th>Gender/Age</th>
            <th>In Time</th>
            <th>Type</th>
            <th>Amount</th>
            <th>User</th>
            <th>Consultant</th>
            <th>Investigation</th>
            <th>Sort Time</th>
        </tr>
    </thead>
    <tbody>
        @php
            $i = 1;
            $UserId = Session::get('UserId');
        @endphp
        @foreach($data as $result)
            @php
                $bgcolor = $result->Dilated ? 'rgb(133 198 205)' : ($result->Appointment ? '#e3e337' : '');
                $OpdTypeName = $result->OpdType == 1 ? 'OPD' : 'App';
                $PayMode = $result->PayMode == 'Mobile Payment' ? 'Online' : $result->PayMode;
            @endphp
            <tr style="background-color: {{ $bgcolor }}">
                <td>
                   
                        <a href="javascript:void(0);" class="update" data-id="{{ $result->MrdNo }}" title="Edit">
                            <i class="fas fa-pencil-alt" style="color: rgb(79, 175, 184);"></i>
                        </a>&nbsp;&nbsp;
                    
                    <a href="javascript:void(0);" onclick="stickerPrint({{ $result->MrdNo }})" title="Print Sticker">
                        <i class="fas fa-print" style="color: rgb(79, 175, 184);"></i>
                    </a>&nbsp;&nbsp;
                    <a href="javascript:void(0);" onclick="patientOut({{ $result->id }}, {{ $result->MrdNo }}, '{{ $result->InDate }}', '{{ $result->PatientName }}')" title="Patient Out">
                        <i class="fas fa-external-link-alt" style="color: rgb(79, 175, 184);"></i>
                    </a>
                </td>
                <td style="text-align: center;"><strong>{{ $i++ }}</strong></td>
                <td>
                    <a href="#" data-toggle="modal" data-target="#modal-report33" onclick="showOptoForm({{ $result->MrdNo }}, {{ $result->id }}, '{{ $result->InDate }}')">
                        <strong>{{ $result->MrdNo }}</strong>
                    </a>
                </td>
                <td>
                    <a href="#" data-toggle="modal" data-target="#modal-report33" onclick="showOptoForm({{ $result->MrdNo }}, {{ $result->id }}, '{{ $result->InDate }}')">
                        <strong>{{ strtoupper(strtolower($result->PatientName)) }}</strong>
                    </a>
                </td>
                <td>{{ $result->Gender }} / {{ $result->Age }}</td>
                <td>{{ \Carbon\Carbon::parse($result->InTime)->format('h:i a') }}</td>
                <td>{{ $result->PatientType }} - ({{ $OpdTypeName }})</td>
                <td>
                    @if($UserId == 58)
                        <a href="javascript:void(0);" class="update2" data-id="{{ $result->id }}">
                            {{ $result->Amount }} - ({{ $PayMode }})
                        </a>
                    @else
                        {{ $result->Amount }} - ({{ $PayMode }})
                    @endif
                </td>
                <td>{{ strtoupper(strtolower($result->CreatedByName)) }}</td>
                <td>{{ strtoupper(strtolower($result->ConsultName)) }}</td>
                <td>{{ strtoupper(strtolower($result->InvStName)) }}</td>
                <td>{{ $result->InTime }}</td>
            </tr>
        @endforeach
    </tbody>
</table>

<script>
    $(document).ready(function () {
        $('#example').DataTable({
            responsive: true,
            pageLength: 50,
            order: [[11, "asc"]],
            columnDefs: [
                { targets: 11, visible: false }
            ]
        });
    });
</script>
