<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 20px 0 1px 0;
        padding: 13px;
        position: relative;
        margin-bottom: 0px;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }
    </style>
</head>
<div class="layout-wrapper layout-1 layout-without-sidenav">
    <div class="layout-inner">


        <div class="layout-container">
            <style>
            table,
            td,
            th {
                border: 1px solid #ddd;
                text-align: left;
            }

            table {
                border-collapse: collapse;
                width: 100%;
            }

            th,
            td {
                padding: 15px;
            }
            </style>
            <div class="layout-content">

                <div class="container-fluid flex-grow-1">

                    <div class="card mb-4">
                        <div class="card-body">
                            <div id="alert_message"></div>
                            <form id="validation-form" action="" method="post" autocomplete="off" enctype="multipart/form-data">
                                <input type="hidden" name="bill_no" value="" id="bill_no">
                                @csrf
                                <fieldset>
                                    <legend>Customer Details</legend>
                                    <div class="form-row">
                                        <div class="form-group col-md-2">
                                            <label class="form-label">Sale Bill No <span
                                                    class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="text" name="BillNo" class="form-control" id="BillNo"
                                                    placeholder="" value="{{$BillNo}}" readonly>
                                                <span class="input-group-append">
                                                    <a class="btn btn-secondary" href="javascript:void(0)"
                                                        data-toggle="modal" data-target="#modal-report" id="add_button"
                                                        onclick="getBillNoList()"><i
                                                            class="feather icon-search"></i></a>
                                                </span>
                                            </div>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="modal fade" id="modal-report" tabindex="-1" role="dialog"
                                            aria-labelledby="myExtraLargeModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" style="max-width: 70rem; ">
                                                <div class="modal-content">
                                                    <div class="modal-body">

                                                        <div class="table-responsive" id="custresult22">

                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label class="form-label">Sale Date <span
                                                    class="text-danger">*</span></label>
                                            <input type="date" name="SaleDate" class="form-control" id="SaleDate"
                                                placeholder="" value="{{date('Y-m-d')}}" required>
                                            <div class="clearfix"></div>
                                        </div>

                                         <div class="form-group col-md-1">
                                            <label class="form-label">MRD No </label>
                                            <input type="text" name="MrdNo" class="form-control" id="MrdNo"
                                                placeholder="" value="" oninput="getPatientDetails()">
                                            <div class="clearfix"></div>
                                        </div> 

                                        <div class="form-group col-md-3">
                                            <label class="form-label">Customer Name <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="PatientName" class="form-control" id="PatientName"
                                                placeholder="" value="" required>
                                            <div class="clearfix"></div>
                                        </div>


                                        <div class="form-group col-md-2">
                                            <label class="form-label">Mobile No</label>
                                            <input type="text" name="MobileNo" class="form-control" id="Phone"
                                                placeholder="" value="" oninput="checkCustDetails()">
                                            <div class="clearfix"></div>
                                        </div>

                                       


                                        <div class="form-group col-md-2">
                                            <label class="form-label">Age/Gender</label>
                                            <input type="text" name="AgeGender" class="form-control" id="AgeGender"
                                                placeholder="" value="">
                                            <div class="clearfix"></div>
                                        </div>

                                        <!--<div class="form-group col-md-2">
                                            <label class="form-label">Address <span class="text-danger">*</span></label>
                                            <input type="text" name="Address" class="form-control" id="Address"
                                                placeholder="" value="" required>
                                            <div class="clearfix"></div>
                                        </div>-->
                                    </div>
                                </fieldset>

                                <div class="form-row">
                                    <div class="col-lg-6">
                                        <fieldset>
                                            <legend>Right Eye</legend>
                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <!--<label class="form-label">Right Eye <span class="text-danger">*</span></label>-->
                                                    <div class="table-responsive" style="overflow-x:auto;">
                                                        <table class="table table-bordered table-striped mb-0">
                                                            <thead>
                                                                <tr>
                                                                    <th width="103">RE</th>
                                                                    <th width="70">SPH</th>
                                                                    <th width="90">CYL</th>
                                                                    <th width="101">AXIS</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>Dist</td>
                                                                    <td>
                                                                        <input class="form-control" list="DataList2"
                                                                            name="SrSphRe" id="SrSphRe" value="">
                                                                        <datalist id="DataList2">


                                                                        </datalist>
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" list="DataList3"
                                                                            name="SrCylRe" id="SrCylRe" value="">
                                                                        <datalist id="DataList3">


                                                                        </datalist>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control"
                                                                            placeholder="" id="SrAxisRe" name="SrAxisRe"
                                                                            value="">
                                                                        <div class="clearfix"></div>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Near Add </td>
                                                                    <td colspan="4">
                                                                        <input class="form-control" list="DataList4"
                                                                            name="SrNearAddRe" id="SrNearAddRe"
                                                                            value="">
                                                                        <datalist id="DataList4">


                                                                        </datalist>
                                                                    </td>
                                                                    <!--  <td>V.A with Glasses </td>
                                                      <td>
                                                           <input type="text" class="form-control" placeholder="" name="SrVaGlassRe" id="SrVaGlassRe"  value="">
                                                            <div class="clearfix"></div>
                                                      </td> -->
                                                                </tr>
                                                                <!-- <tr>
                                                      <td>N.V</td>
                                                      <td> <input class="form-control" list="DataList5" name="SrNvRe" id="SrNvRe"  value="">
                                                            <datalist id="DataList5">
                                                                
                                                        
                                                                    </datalist></td>
                                                      <td>&nbsp;</td>
                                                      <td>&nbsp;</td>
                                                    </tr> -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>

                                    <div class="col-lg-6">
                                        <fieldset>
                                            <legend>Left Eye</legend>

                                            <div class="form-group col-md-12">
                                                <!--<label class="form-label">Left Eye <span class="text-danger">*</span></label>-->
                                                <div class="table-responsive" style="overflow-x:auto;">
                                                    <table class="table table-bordered table-striped mb-0">
                                                        <thead>
                                                            <tr>
                                                                <th width="103">LE</th>
                                                                <th width="70">SPH</th>
                                                                <th width="90">CYL</th>
                                                                <th width="101">AXIS</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>Dist</td>
                                                                <td>
                                                                    <input class="form-control" list="" name="SrSphLe"
                                                                        id="SrSphLe" value="">
                                                                    <datalist id="DataList4">


                                                                    </datalist>
                                                                </td>
                                                                <td>
                                                                    <input class="form-control" list="" name="SrCylLe"
                                                                        id="SrCylLe" value="">
                                                                    <datalist id="DataList3">


                                                                    </datalist>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control"
                                                                        placeholder="" name="SrAxisLe" id="SrAxisLe"
                                                                        value="">
                                                                    <div class="clearfix"></div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Near Add </td>
                                                                <td colspan="4">
                                                                    <input class="form-control" list=""
                                                                        name="SrNearAddLe" id="SrNearAddLe" value="">
                                                                    <datalist id="DataList4">


                                                                    </datalist>
                                                                </td>
                                                                <!--  <td>V.A with Glasses </td>
                                                      <td>
                                                          <input type="text" class="form-control" placeholder="" name="SrVaGlassLe" id="SrVaGlassLe" value="">
                                                            <div class="clearfix"></div>
                                                      </td> -->
                                                            </tr>
                                                            <!--  <tr>
                                                      <td>N.V</td>
                                                      <td> <input class="form-control" list="DataList5" name="SrNvLe" id="SrNvLe"  value="">
                                                            <datalist id="DataList5">
                                                                
                                                        
                                                                    </datalist></td>
                                                      <td>&nbsp;</td>
                                                      <td>&nbsp;</td>
                                                    </tr> -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                        </fieldset>
                                    </div>
                                </div>

                                <fieldset>
                                    <legend>Frame Details</legend>
                                    <div class="form-row">
                                        <div class="form-group col-md-3">
                                            <label class="form-label">Frame Name <span
                                                    class="text-danger">*</span></label>
                                            <input class="form-control" list="FrameName2" name="FrameName"
                                                id="FrameName">
                                            <datalist id="FrameName2">
                                            @foreach($itemlist as $result)
                                    <option value="{{$result->FrameName}}">{{$result->FrameName}}</option>
                                    @endforeach

                                            </datalist>

                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Qty <span class="text-danger">*</span></label>
                                            <input type="text" name="Qty" class="form-control" id="Qty" placeholder=""
                                                value="1" onKeyPress="return isNumberKey(event)" 
                                                oninput="ItemAmount(document.getElementById('Qty').value,
                                                document.getElementById('FrameRate').value,
                                                document.getElementById('GlassRate').value)">
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Rate <span class="text-danger">*</span></label>
                                            <input type="text" name="FrameRate" class="form-control" id="FrameRate"
                                                placeholder="" value="" onKeyPress="return isNumberKey(event)"
                                                oninput="ItemAmount(document.getElementById('Qty').value,document.getElementById('FrameRate').value,document.getElementById('GlassRate').value)">
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label class="form-label">Glass Name <span
                                                    class="text-danger">*</span></label>
                                            <input class="form-control" list="GlassName2" name="GlassName"
                                                id="GlassName">
                                            <datalist id="GlassName2">


                                            </datalist>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Glass Rate <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="GlassRate" class="form-control" id="GlassRate"
                                                placeholder="" value="" onKeyPress="return isNumberKey(event)"
                                                oninput="ItemAmount(document.getElementById('Qty').value,document.getElementById('FrameRate').value,document.getElementById('GlassRate').value)">
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label class="form-label">Amount <span class="text-danger">*</span></label>
                                            <input type="text" name="Amount" class="form-control" id="Amount"
                                                placeholder="" value="" readonly>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">&nbsp;</label>
                                            <button id="addItem" class="btn btn-success" onclick="addItemFrame()"
                                                type="button">Add</button>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <div class="table-responsive" id="custresult">

                                            </div>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset>
                                    <legend>Total Bill</legend>
                                    <div class="form-row">
                                        <div class="form-group col-md-1">
                                            <label class="form-label">Sub Total <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="SubTotal" class="form-control" id="SubTotal"
                                                placeholder="" value="" readonly style="height:31px;">
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Advance <span class="text-danger">*</span></label>
                                            <input type="text" name="Advance" class="form-control" id="Advance"
                                                style="height:31px;" placeholder="" value=""
                                                onKeyPress="return isNumberKey(event)"
                                                oninput="netAmount(document.getElementById('SubTotal').value,document.getElementById('Advance').value)"
                                                required>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Net Amount <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="NetAmount" class="form-control" id="NetAmount"
                                                style="height:31px;" placeholder="" value="" readonly>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label class="form-label">Pay. Mode <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" id="PayMode" name="PayMode" required
                                                style="height:31px;">
                                                <option value="Cash">Cash</option>
                                                <option value="Card">Card</option>
                                                <option value="Mobile Payment">Mobile Payment</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-1">
                                            <label class="form-label">Delivery Date <span
                                                    class="text-danger">*</span></label>
                                            <input type="date" name="DeliveryDate" class="form-control"
                                                style="height:31px;" id="DeliveryDate" placeholder="" value="{{date('Y-m-d')}}"
                                                required>
                                            <div class="clearfix"></div>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label class="form-label">Narration</label>
                                            <textarea class="form-control" name="Narration"
                                                style="height: 31px;"></textarea>
                                        </div>

                                        <div class="form-group col-md-2" style="padding-top: 25px;">
                                            <label class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" value="1"
                                                    name="WorkComplete">
                                                <span class="custom-control-label">Work Completed</span>
                                            </label>
                                        </div>

                                        <div class="form-group col-md-2" style="padding-top: 25px;">
                                            <label class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" value="1"
                                                    name="MakeOrder">
                                                <span class="custom-control-label">Make Order</span>
                                            </label>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <button type="submit" name="submit" class="btn btn-primary btn-finish"
                                                id="submit">Save</button>
                                        </div>
                                    </div>
                                </fieldset>
                                <!-- <button id="growl-default" class="btn btn-default">Default</button> -->

                            </form>
                        </div>
                    </div>






                </div>


            </div>

        </div>

    </div>

    <div class="layout-overlay layout-sidenav-toggle"></div>
</div>

@include('footerscript')
<script>
function print() {
    var BillNo = $('#BillNo').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printOpticalReceipt/' + BillNo, 'name',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=1500, height=1000'
        );
    }, 1);
}

function getBillNoList() {
    var action = 'getBillNoList';
    $.ajax({
        type: "POST",
        url: "{{ url('getBillNoList') }}",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#custresult22').html(data);
        }
    });
}

function checkCustDetails() {
    var Phone = $('#Phone').val();
    $.ajax({
        type: "POST",
        url: "{{url('checkCustDetails') }}",
        data: {
            _token: '{{csrf_token()}}',
            Phone: Phone
        },
        dataType: "json",
        success: function(data) {
            console.log(data);
            $('#PatientName').val(data.PatientName);
            $('#AgeGender').val(data.AgeGender);
            $('#Address').val(data.Address);
        }
    });
}

function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function searchBillNo(val) {
    window.location.href = 'create-sale-bill.php?billno=' + val;
}

function ItemAmount(qty, frate, grate) {
    var TotAmount = (Number(qty) * Number(frate)) + Number(grate);
    $('#Amount').val(parseFloat(TotAmount).toFixed(2));
}

function netAmount(SubTotal, Advance) {
    var NetAmount = Number(SubTotal) - Number(Advance);
    $('#NetAmount').val(parseFloat(NetAmount).toFixed(2));
}

function getPatientDetails() {
    var val = $('#MrdNo').val();
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            console.log(data);
            var AgeGender = data.Age + "/" + data.Gender;
            $('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName+" - "+data.MrdNo);
            $('#AgeGender').val(AgeGender);
            $('#Phone').val(data.Phone);
            $('#Address').val(data.Address);
            getSubRefract(data.MrdNo);
        }
    });
}

function getSubTotal(BillNo, MrdNo) {
    /*var sum = 0;
        $(".txt2").each(function() {
        if(!isNaN(this.value) && this.value.length!=0) {
          sum += parseFloat(this.value);
        }
     });
     $('#SubTotal').val(sum);
     */
    var action = 'getSubTotal';
    var Advance = $('#Advance').val();
    $.ajax({
        type: "POST",
        url: "{{ url('getItemSubTotal') }}",
        data: {
            _token: '{{csrf_token()}}',
            BillNo: BillNo,
            MrdNo: MrdNo
        },
        success: function(data) {
            console.log(data);
            $('#SubTotal').val(parseFloat(data).toFixed(2));
            netAmount(data, Advance);
        }
    });

}

function itemLists(BillNo, MrdNo) {
    var action = 'itemLists';
    $.ajax({
        type: "POST",
        url: "{{ url('itemLists') }}",
        data: {
            _token: '{{csrf_token()}}',
            BillNo: BillNo,
            MrdNo: MrdNo
        },
        success: function(data) {
            $('#custresult').html(data);
        }
    });
}

function addItemFrame() {
    var BillNo = $('#BillNo').val();
    var MrdNo = $('#MrdNo').val();
    var FrameName = $('#FrameName').val();
    var Qty = $('#Qty').val();
    var FrameRate = $('#FrameRate').val();
    var GlassName = $('#GlassName').val();
    var GlassRate = $('#GlassRate').val();
    var Amount = $('#Amount').val();
    var action = "addItem";
    if (FrameName == '') {
        alert("Please Select Frame");
    } else if (Qty == '') {
        alert("Please Enter Frame Qty");
    } else {
        $.ajax({
            url: "{{ url('addItem') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                BillNo: BillNo,
                MrdNo: MrdNo,
                FrameName: FrameName,
                Qty: Qty,
                FrameRate: FrameRate,
                GlassName: GlassName,
                GlassRate: GlassRate,
                Amount: Amount
            },
            beforeSend: function() {
                $('#addItem').attr('disabled', 'disabled');
                $('#addItem').text('Please Wait...');
            },
            success: function(data) {
                //alert(data);
                console.log(data);
                itemLists(BillNo, MrdNo);
                $('#addItem').attr('disabled', false);
                $('#addItem').text('Add');
                $('#FrameName').val('').attr("selected", true);
                $('#Qty').val('');
                $('#FrameRate').val('');
                $('#GlassName').val('');
                $('#GlassRate').val('');
                $('#Amount').val('');
                getSubTotal(BillNo, MrdNo);
            }
        });
    }
}

function getSubRefract(mrdno) {
    var action = "getSubRefract";
    $.ajax({
        url: "{{ url('getSubRefract') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            mrdno: mrdno
        },
        success: function(data) {
            console.log(data);
            var res = JSON.parse(data);
            $('#SrSphRe').val(res.SrSphRe);
            $('#SrCylRe').val(res.SrCylRe);
            $('#SrAxisRe').val(res.SrAxisRe);
            $('#SrNearAddRe').val(res.SrNearAddRe);
            $('#SrVaGlassRe').val(res.SrVaGlassRe);
            $('#SrNvRe').val(res.SrNvRe);

            $('#SrSphLe').val(res.SrSphLe);
            $('#SrCylLe').val(res.SrCylLe);
            $('#SrAxisLe').val(res.SrAxisLe);
            $('#SrNearAddLe').val(res.SrNearAddLe);
            $('#SrVaGlassLe').val(res.SrVaGlassLe);
            $('#SrNvLe').val(res.SrNvLe);
        }
    });
}
$(document).ready(function() {
    $('#MrdNo').focus();
    var bill_no = $('#bill_no').val();
    var MrdNo = $('#MrdNo').val();
    if (bill_no != '') {
        itemLists(bill_no, MrdNo);
    }
    

    $(document).on("change", "#FrameName", function(event) {
        var val = this.value;
        var grate = $('#GlassRate').val();
   var qty = $('#Qty').val();
    $.ajax({
        type: "POST",
        url: "{{ url('getFrameDetails') }}",
        data: {
            Name: val,
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            console.log(data);
            var res = JSON.parse(data);
            var Code = res.Code;
            var Rate = res.Rate;
            var status = res.status;
            var srno = res.srno;
            if (status == 0) {
                $('#FrameRate').val('');
            } else {
              
                $('#FrameRate').val(Rate);
                ItemAmount(qty,Rate,grate);
                
            }
           

        }
    });


    });

    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        var BillNo = $('#BillNo').val();
        var MrdNo = $('#MrdNo').val();
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Item!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteTempFrameItem') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        swal("Deleted!", "Item has been deleted.", "success");

                        itemLists(BillNo, MrdNo);
                        getSubTotal(BillNo, MrdNo);

                    }
                });

            } else {
                swal("Cancelled", "Item is safe :)", "error");
            }
        });


    });

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveSaleBill') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Save');
                    
                    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printOpticalReceipt/' + data, 'name22',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=1500, height=1000'
        );
        window.location.href="/{{projectUrl()}}saleBill";
    }, 1);
                }
            });
        }
    });


});
</script>