@include('header')
@php
if(file_exists('json_files/json-file.json')){
$json = file_get_contents('json_files/json-file.json');
//Decode JSON
$json_data = json_decode($json,true);
$results = array();
}
@endphp
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Item Master</h4>


    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center m-l-0">



                        <div class="col-sm-2 text-left">
                            <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                                data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add Item
                                Master</button>
                        </div>


                    </div>
                    <hr>
                    <div class="table-responsive" id="custresult">

                    </div>
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>


    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width: 70rem; ">
            <div class="modal-content">


                <div class="modal-header">
                    <h5 class="modal-title">Add Item Master</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="validation-form" method="POST">
                        <div class="row">

                            <input type="hidden" name="action" id="action" value="Save">
                            <input type="hidden" name="id" id="id" />
                            <input type="hidden" name="srno" id="srno" />
                            @csrf
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Item Code <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Code" id="Code" placeholder=""
                                        readonly value="">
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Item Master Name <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" list="DataList2" name="Name" id="Name" value=""
                                        required="" 
                                        oninput="getFrameDetails()">
                                    <datalist id="DataList2">
                                    @foreach($itemlist as $result)
                                    <option value="{{$result->FrameName}}">{{$result->FrameName}}</option>
                                    @endforeach
                                    </datalist>

                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Total Qty <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Qty" id="Qty" placeholder=""
                                        onKeyPress="return isNumberKey(event)" required="">
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Rate <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Rate" id="Rate" placeholder=""
                                        onKeyPress="return isNumberKey(event)" required="">
                                </div>
                            </div>

                            <!-- <div class="col-sm-12">
                            <div class="form-group">
                                <label class="floating-label" for="Name">Description </label>
                                <input type="text" class="form-control" name="Details" id="Details" placeholder="" >
                            </div>
                        </div> -->

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Add/Minus <span
                                            class="text-danger">*</span></label>
                                    <select class="form-control" id="AddMinus" name="AddMinus" required="">
                                        <option value="+" selected="">+</option>
                                        <option value="-">-</option>
                                    </select>
                                    <div class="clearfix"></div>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Status <span
                                            class="text-danger">*</span></label>
                                    <select class="form-control" id="Status" name="Status" required="">
                                        <option value="1" selected="">Active</option>
                                        <option value="2">Inctive</option>
                                    </select>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                                <button class="btn btn-danger" type="reset">Clear</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</div>

@include('footerscript')
<script type="text/javascript">
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Item Master Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Item Master Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function getFrameDetails() {
    var Name = $('#Name').val();
    var action = 'getFrameDetails';
    $.ajax({
        type: "POST",
        url: "{{ url('getFrameDetails') }}",
        data: {
            Name: Name,
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            console.log(data);
            var res = JSON.parse(data);
            var Code = res.Code;
            var Rate = res.Rate;
            var status = res.status;
            var srno = res.srno;
            if (status == 0) {
                itemCode();
                $('#Rate').val('');
            } else {
                $('#Code').val(Code);
                $('#Rate').val(Rate);
                $('#srno').val(srno);
            }

        }
    });
}

function itemCode() {
    var action = 'itemCode';
    $.ajax({
        type: "POST",
        url: "{{ url('itemCode') }}",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            console.log(data);
            var res = JSON.parse(data);
            var Code = res.Code;
            var srno = res.srno;
            $('#Code').val(Code);
            $('#srno').val(srno);
        }
    });
}

function itemmaster_lists() {
    var action = 'view';
    $.ajax({
        type: "POST",
        url: "{{ url('viewItemList') }}",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //consoloe.log(data);
            $('#custresult').html(data);
        }
    });
}

$(document).ready(function() {
    itemmaster_lists();
    itemCode();
    $('#add_button').click(function() {
        itemCode();
        $('.modal-title').html("Add <span class='font-weight-light'>New Item Master</span>");
        $('#action').val("Save");
        $('#id').val('');

        $('#ItemType').val(null).attr("selected", true);
        $('#Status').attr("selected", "selected").val(1);
        $('#Name').val('');
        $('#Details').val('');
        $('#Rate').val('');
        $('#Qty').val('');
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveItem') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    //alert(data);exit();
                    if (data == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        itemmaster_lists();
                        itemCode();

                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
        }
    });


    
});
</script>
