
<table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
    <thead>
        <tr>
        <th>#</th>
                <th>Bill No</th>
                <th>Sale Date</th>
                <th>Patient Name</th>
                <th>Mobile No</th>
                <th>Subtotal</th>
                <th>Advance</th>
                <th>Balance</th>
                <th>Payment Mode</th>
                <th>Delivery Date</th>
        </tr>
    </thead>
    <tbody>
        @php $i=1;@endphp
        @foreach($data as $result)
        <tr>

            <td>{{$i}}</td>
            <td>{{$result->BillNo}}</td>
            <td>{{date("d/m/Y", strtotime(str_replace('-', '/',$result->SaleDate)))}}</td>
            <td>{{$result->PatientName}}</td>
            <td>{{$result->MobileNo}}</td>
            <td>&#8377;{{number_format($result->SubTotal,2)}}</td>
            <td>&#8377;{{number_format($result->Advance,2)}}</td>
            <td>&#8377;{{number_format($result->NetAmount,2)}}</td>
            <td>{{$result->PayMode}}</td>
            <td>{{date("d/m/Y", strtotime(str_replace('-', '/',$result->DeliveryDate)))}}</td>
        </tr>
        @php $i++;@endphp
    @endforeach

    </tbody>
</table>
<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
        "scrollX": true,
        dom: 'Bfrtip',
        "pageLength": 200,
        "order": [
            [0, "desc"]
        ],
        buttons: [

            'excelHtml5'

        ]
    });
});
</script>