<table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
    <thead>
        <tr>
            <th>#</th>
            <th>Bill No</th>
            <th>Sale Date</th>
            <th>Patient Name</th>
            <!-- <th>Mobile No</th> -->
            <th>Subtotal</th>
            <th>Advance</th>
            <th>Paid</th>
            <th>Balance</th>
            <th>Payment Mode</th>
        </tr>
    </thead>
    <tbody>
        @php $i=1;@endphp
        @foreach($data as $result)
        @if($result->Roll == 1)
        @php $PaidAmount = 0; @endphp
        @else
        @php $PaidAmount = $result->PaidAmount; @endphp
        @endif
        <tr>

            <td>{{$i}}</td>
            <td>{{$result->BillNo}}</td>
            <td>{{date("d/m/Y", strtotime(str_replace('-', '/',$result->SaleDate)))}}</td>
            <td>{{$result->PatientName}}</td>
            <!-- <td>{{$result->MobileNo}}</td> -->
            <td>&#8377;{{number_format($result->SubTotal,2)}}</td>
            <td>&#8377;{{number_format($result->Advance,2)}}</td>
            
            <td>&#8377;{{number_format($PaidAmount,2)}}</td>
            <td>&#8377;{{number_format($result->NetAmount,2)}}</td>
            <td>{{$result->PayMode}}</td>
            
        </tr>
        @php $i++;@endphp
        @endforeach

        <tr>
                    
        <td>{{$i}}</td>
                   <th></th>
                   <th></th>
                  <!--  <th></th> -->
                    <th>Total</th>
                    <th>&#8377;{{number_format($Total,2)}}</th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                   <!--  <th></th> -->
               </tr>

    </tbody>
</table>
<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
        "scrollX": true,
        dom: 'Bfrtip',
        "pageLength": 200,
        "order": [
            [0, "asc"]
        ],
        buttons: [

            'excelHtml5'

        ]
    });
});
</script>