@extends('layout')

@section('content')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Make Order</h4>
    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>
            <form id="validation-form" method="post" enctype="multipart/form-data">
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label class="form-label">From Date </label>
                        <input type="date" name="FromDate" id="FromDate" class="form-control" value="{{date('Y-m-d')}}"
                            autocomplete="off">
                    </div>
                    <div class="form-group col-md-3">
                        <label class="form-label">To Date</label>
                        <input type="date" name="ToDate" id="ToDate" class="form-control" value="{{date('Y-m-d')}}"
                            autocomplete="off">
                    </div>
                    <input type="hidden" name="Search" value="Search">
                    <div class="form-group col-md-2" style="padding-top:20px;">
                    <button type="button" id="filter" class="btn btn-primary btn-finish">Search</button>
                    </div>
                </div>

            </form>
        </div>
    </div>
    <style>
    table,
    td,
    th {
        border: 1px solid #ddd;
        text-align: left;
    }

    table {
        border-collapse: collapse;
        width: 100%;
    }

    th,
    td {
        padding: 15px;
    }
    </style>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                <div class="table-responsive" id="custresult">

                        
                </div>
                </div>

            </div>
        </div>
        <!-- customar project  end -->
    </div>



</div>
@endsection
@section('scriptcontent')
<script>
    $(document).ready(function() {
        $('#filter').click(function() {
            var FromDate = $('#FromDate').val();
            var ToDate = $('#ToDate').val();
            if (FromDate != '' && ToDate!= '') {
                //$('.yajra-datatable').DataTable().destroy();
                //load_data(FromDate, ToDate);
                queueList(FromDate,ToDate);
            } else {
                alert('Both Date is required');
            }
        });

        $('#refresh').click(function() {
            $('#FromDate').val('');
            queueList();
        });

        function queueList(FromDate = '',ToDate = '') {
            $.ajax({
                url: "{{ url('viewMakeOrder') }}",
                method: "POST",
                data: {
                    _token: '{{csrf_token()}}',
                    FromDate: FromDate,
                    ToDate:ToDate
                },
                success: function(data) {
                    console.log(data);
                    $('#custresult').html(data);
                }
            });
        }
    });
    </script>
@endsection