@php $totalamt = 0; @endphp
<table id="example99" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
            <th>Mrd. No</th>
            <th>Patient Name</th>
            <th>Visit Date</th>
            <th>Address</th>
            <th>Phone</th>
            <th>Investigation</th>
            <th>Amount</th>
            <th>Consultant</th>
            <th>Money Received By</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data as $result)
        @php $totalamt += $result->Amount; @endphp
        <tr>
            <td>{{ $result->MrdNo }}</td>
            <td>{{ strtoupper(strtolower($result->PatientName)) }}</td>
            <td>{{ \Carbon\Carbon::parse($result->VisitDate)->format('d/m/Y') }}</td>
            <td>{{ $result->Address }}</td>
            <td>{{ $result->Phone }}</td>
            <td style="white-space: pre-wrap;">{{ $result->InvStName }}</td>
            <td style="white-space: pre-wrap;">{{ number_format($result->Amount, 2) }}</td>
            <td>{{ $result->Name ?? '' }}</td>
            <td>{{ $result->MoneyRecName ?? '' }}</td>
        </tr>
        @endforeach
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <th>Total</th>
            <th>{{ number_format($totalamt, 2) }}</th>
            <td></td>
            <td></td>
        </tr>
    </tbody>
</table>
<script type="text/javascript">
$(document).ready(function() {
    $('#example99').DataTable({
        scrollX: true,             // Horizontal scroll
        fixedHeader: true,         // Fix thead at top
        pageLength: 5000,           // Show 500 rows
        dom: 'Bfrtip',             // Export buttons on top
        buttons: ['excelHtml5'],    // Excel export
        "scrollY": "400px"
    });
});
</script>