<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <script src="{{url('ckeditor/ckeditor.js')}}"></script>
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 15px 0 1px 0;
        padding: 10px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
    }
    </style>

</head>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Send Brochures</h4>

    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        @csrf
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">

                        <div class="form-row">
                            <div class="form-group col-lg-2">
                                <label class="form-label">MRD No.</label>
                                <input type="text" name="MrdNo" id="MrdNo" class="form-control" value="" placeholder="" style="height: 35px;">
                                <div class="clearfix"></div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">Patient Name</label>
                                <input type="text" name="PatientName" id="PatientName" class="form-control" value="" placeholder="" style="height: 35px;">
                                <div class="clearfix"></div>
                            </div>
                            <div class="form-group col-lg-2">
                                <label class="form-label">Phone</label>
                                <input type="text" name="Phone" id="Phone" class="form-control" value="" placeholder="" style="height: 35px;">
                                <div class="clearfix"></div>
                            </div>

                            <div class="form-group col-lg-4">
                            <label class="form-label">File Name</label>
                            <select class="form-control" data-allow-clear="true"
                                    name="BrochureId" id="BrochureId" style="height: 35px;">
                                    <option value="" selected="">...</option>
                                    @foreach($brochurelist as $result)
                                    <option value="{{$result->id}}">
                                        {{$result->Name}}
                                    </option>
                                    @endforeach
                            </select>
                            </div>

                             <div class="form-group col-lg-12">
                             <label class="form-label">Meesage</label>
                                <textarea name="Message" class="form-control" placeholder="Message"
                                    required style="height: 120px;"></textarea>
                                <div class="clearfix"></div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <button type="submit" name="submit" class="btn btn-primary btn-finish"
                                        id="submit">Send</button>
                                </div>
                            </div>
                            </div>






                        </div>
                    </div>
                </div>

            </div>
    </form>





</div>
@include('footerscript')

<script>
//CKEDITOR.replace('editor1');

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'SMS Sent Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'SMS Not Sent. Please Try Again!!!',
        location: isRtl ? 'tl' : 'tr'
    });
}

$(document).ready(function() {
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
            $.ajax({
                url: "{{ url('SaveBrochure') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    console.log(data);
                   
                    if (data == 1) {
                        success_toast();
                        setTimeout(function () {
                            window.close();
                        }, 1000);
                        
                    } else {
                        error_toast();
                       
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
      
    });


    $(document).on("input", "#MrdNo", function(event) {
    var val = this.value;
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            //console.log(data);
            $('#PatientName').val(data.PatientName);
            $('#Phone').val(data.Phone);

        }
    });

});
});
</script>