<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <script src="{{url('ckeditor/ckeditor.js')}}"></script>
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 15px 0 1px 0;
        padding: 10px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
    }
    </style>

</head>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Preview WhatsApp SMS</h4>

    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        @csrf
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">

                        <div class="form-row">
                            <div class="form-group col-lg-2">
                                <label class="form-label">MRD No.</label>
                                <input type="text" name="MrdNo" class="form-control" value="{{$result->MrdNo}}" placeholder="" readonly>
                                <div class="clearfix"></div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">Patient Name</label>
                                <input type="text" name="PatientName" class="form-control" value="{{$result->PatientName}}" placeholder="">
                                <div class="clearfix"></div>
                            </div>
                            <div class="form-group col-lg-2">
                                <label class="form-label">Phone</label>
                                <input type="text" name="Phone" class="form-control" value="{{$result->Phone}}" placeholder="">
                                <div class="clearfix"></div>
                            </div>
                            <input type="hidden" name="ReferFor" class="form-control" value="{{$result->ReferFor}}" placeholder="" readonly>
                            <input type="hidden" name="Consultant" class="form-control" value="{{$result->Consultant}}" placeholder="" readonly>
                            <input type="hidden" name="AppId" class="form-control" value="{{$id}}" placeholder="" readonly>
                            <input type="hidden" name="AppDate" class="form-control" value="{{$result->AppDate}}" placeholder="" readonly>
                            <input type="hidden" name="AppTime" class="form-control" value="{{$result->AppTime0}}" placeholder="" readonly>
                            <div class="form-group col-lg-12">
                                <textarea name="Message" class="form-control" id="editor1" placeholder="Message"
                                    required>{{$msg}}</textarea>
                                <div class="clearfix"></div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <button type="submit" name="submit" class="btn btn-primary btn-finish"
                                        id="submit">Send</button>
                                </div>
                            </div>
                            </div>






                        </div>
                    </div>
                </div>

            </div>
    </form>





</div>
@include('footerscript')

<script>
CKEDITOR.replace('editor1');

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'SMS Sent Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'SMS Not Sent. Please Try Again!!!',
        location: isRtl ? 'tl' : 'tr'
    });
}

$(document).ready(function() {
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
            $.ajax({
                url: "{{ url('sendWhatsappSms') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {

                   
                    if (data == 1) {
                        success_toast();
                        setTimeout(function () {
                            window.close();
                        }, 1000);
                        
                    } else {
                        error_toast();
                       
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
      
    });
});
</script>