<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="icon" type="image/x-icon" href="<?php echo e(url('assets/img/favicon.jpg')); ?>">

    <?php
        function assetVersion($path)
        {
            $fullPath = public_path($path);
            return file_exists($fullPath) ? filemtime($fullPath) : time();
        }
    ?>

    <!-- Fonts -->
    <link href="<?php echo e(url('assets/fonts/roboto.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/roboto.css')); ?>" rel="stylesheet">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/fonts/fontawesome.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/fontawesome.css')); ?>">

    <!-- Core CSS -->
    <link rel="stylesheet"
        href="<?php echo e(url('assets/css/bootstrap-material.css')); ?>?v=<?php echo e(assetVersion('assets/css/bootstrap-material.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/css/shreerang-material.css')); ?>?v=<?php echo e(assetVersion('assets/css/shreerang-material.css')); ?>">

    <!-- DataTables -->
    <link rel="stylesheet"
        href="<?php echo e(url('assets/libs/datatables/datatables.css')); ?>?v=<?php echo e(assetVersion('assets/libs/datatables/datatables.css')); ?>">

    <style>
        .autocomplete-list {
            border: 1px solid #ccc;
            max-height: 150px;
            overflow-y: auto;
            position: absolute;
            background-color: white;
            z-index: 1000;
            width: 100%;
        }

        .autocomplete-item {
            padding: 8px;
            cursor: pointer;
        }

        .autocomplete-item:hover,
        .autocomplete-item.active {
            background-color: #98e6ed;
        }
    </style>
</head>

<body>
    <div class="container-fluid flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <h3>Patient Counselling List</h3>
                        <table id="example33" class="table table-striped table-bordered dt-responsive nowrap"
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th>Record Id</th>
                                    <th>Mrd. No</th>
                                    <th>Visit Date</th>
                                    <th>Patient Name</th>
                                    <th>Remark</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($result->MrdNo); ?></td>
                                        <td><?php echo e($result->VisitDate); ?></td>
                                        <td><?php echo e(strtoupper(strtolower($result->PatientName))); ?></td>
                                        <td><?php echo e($result->CouncRemark); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary"
                                                onclick="openRemarkModal(
            '<?php echo e($result->id); ?>',
            '<?php echo e($result->MrdNo); ?>',
            '<?php echo e($result->VisitDate); ?>',
            '<?php echo e(addslashes($result->PatientName)); ?>',
            '<?php echo e(addslashes($result->CouncRemark)); ?>'
        )">
                                                Update Remark
                                            </button>

                                            <button type="button" class="btn btn-sm btn-danger"
                                                onclick="handlePtOut('<?php echo e($result->id); ?>')">
                                                PT Out
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="remarkModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width: 50rem;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Patient Remark</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <form id="validation-form" method="POST" action="">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" id="InvId">

                        <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Mrd. No <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="MrdNo" id="MrdNo" readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Visit Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="VisitDate" id="CreatedDate"
                                        readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Patient Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="PatientName" id="PatientName"
                                        readonly>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Remark <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="CouncRemark" id="Narration" rows="3" required></textarea>
                                </div>
                            </div>

                            <div class="col-sm-12 text-right">
                                <button class="btn btn-primary" type="submit" id="submit"
                                    name="submit">Submit</button>
                                

                            </div>

                            <input type="hidden" id="btnaction" value="submit">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- JavaScript Includes -->
    <script src="<?php echo e(url('assets/js/jquery-3.6.0.min.js')); ?>?v=<?php echo e(assetVersion('assets/js/jquery-3.6.0.min.js')); ?>">
    </script>
    <script src="<?php echo e(url('assets/js/bootstrap.js')); ?>?v=<?php echo e(assetVersion('assets/js/bootstrap.js')); ?>"></script>
    <script
        src="<?php echo e(url('assets/libs/datatables/datatables.js')); ?>?v=<?php echo e(assetVersion('assets/libs/datatables/datatables.js')); ?>">
    </script>

    <!-- Optional if needed for layout -->
    <script src="<?php echo e(url('assets/js/sidenav.js')); ?>?v=<?php echo e(assetVersion('assets/js/sidenav.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/layout-helpers.js')); ?>?v=<?php echo e(assetVersion('assets/js/layout-helpers.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/material-ripple.js')); ?>?v=<?php echo e(assetVersion('assets/js/material-ripple.js')); ?>"></script>
    <?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function() {
            $('#example33').DataTable({
                responsive: true,
                pageLength: 50,
                order: [
                    [2, 'asc']
                ],
                "scrollX": true,
        dom: 'Bfrtip',
        buttons: [

            'excelHtml5'

        ]
            });



            $('#validation-form').on('submit', function(e) {
                e.preventDefault();
                $.ajax({
                    url: "<?php echo e(url('saveCounsellingRemark')); ?>",
                    method: "POST",
                    data: new FormData(this),
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $('#submit').attr('disabled', 'disabled');
                        $('#submit').text('Please Wait...');
                    },
                    success: function(data) {
                        if (data == 1) {
                            alert("Updated successfully!");
                            window.location.href = '/<?php echo e(projectUrl()); ?>opdCounsellingList';
                            $('#submit').attr('disabled', false).text('Submit');
                            $('#modal-report').modal('hide');
                        } else {
                            $('#submit').attr('disabled', false).text('Submit');
                            $('#modal-report').modal('show');
                        }
                    }
                });
            });
        });

        function openRemarkModal(id, mrdNo, visitDate, patientName, remark) {
            $('#InvId').val(id);
            $('#MrdNo').val(mrdNo);
            $('#CreatedDate').val(visitDate);
            $('#PatientName').val(patientName);
            $('#Narration').val(remark); // using Narration as remark field
            $('#modal-report').modal('show');
        }

        function handlePtOut(id) {
            if (confirm("Are you sure you want to mark this patient as 'PT Out'?")) {
                $.ajax({
                    url: "<?php echo e(url('counsellingPtOut')); ?>",
                    method: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id
                    },
                    success: function(data) {
                        if (data == 1) {
                            alert("Patient Out successfully!");
                            window.location.href = '/<?php echo e(projectUrl()); ?>opdCounsellingList';
                        }
                        
                    }
                });
            }
        }
    </script>
</body>

</html>
<?php /**PATH D:\Projects\Sidhha_Tech\st_projects\Laravel\deshmukh_hosp\resources\views//ipd/view-opd-counselling-list.blade.php ENDPATH**/ ?>