<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    <?php echo $__env->make('headerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</head>
<style>
    #cover-spin {
    position:fixed;
    width:100%;
    left:0;right:0;top:0;bottom:0;
    background-color: rgba(255,255,255,0.7);
    z-index:9999;
    display:none;
}

@-webkit-keyframes spin {
	from {-webkit-transform:rotate(0deg);}
	to {-webkit-transform:rotate(360deg);}
}

@keyframes spin {
	from {transform:rotate(0deg);}
	to {transform:rotate(360deg);}
}

#cover-spin::after {
    content:'';
    display:block;
    position:absolute;
    left:48%;top:40%;
    width:40px;height:40px;
    border-style:solid;
    border-color:rgb(79, 175, 184);
    border-top-color:transparent;
    border-width: 4px;
    border-radius:50%;
    -webkit-animation: spin .8s linear infinite;
    animation: spin .8s linear infinite;
}
    </style>
<div class="container-fluid flex-grow-1 container-p-y">
    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h3><?php echo e($Label); ?></h3>
                    <table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                        <tr style="background-color: rgb(65, 110, 110);color: white;">
                               
                    
                                <th>Sr.No</th>
            <th>MRD No</th>
            <th>Name</th>
            <th>Gender/Age</th>
            <th>In Time</th>
            <th>Type</th>
            <th>Amount</th>
            <th>User</th>
            <th>Consultant</th>
            <th>Investigation</th>
                              
                                <th>Action</th>
                               
                              
                            </tr>
                        </thead>
                        <tbody>
                    
                           <?php
            $i = 1;
            $UserId = Session::get('UserId');
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $bgcolor = $result->Dilated ? 'rgb(133 198 205)' : ($result->Appointment ? '#e3e337' : '');
                $OpdTypeName = $result->OpdType == 1 ? 'OPD' : 'App';
                $PayMode = $result->PayMode == 'Mobile Payment' ? 'Online' : $result->PayMode;
            ?>
            <tr style="background-color: <?php echo e($bgcolor); ?>">
                
                <td style="text-align: center;"><strong><?php echo e($i++); ?></strong></td>
                <td>
                    <a href="#">
                        <strong><?php echo e($result->MrdNo); ?></strong>
                    </a>
                </td>
                <td>
                    <a href="#">
                        <strong><?php echo e(strtoupper($result->PatientName)); ?></strong>
                    </a>
                </td>
                <td><?php echo e($result->Gender); ?> / <?php echo e($result->Age); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($result->InTime)->format('h:i a')); ?></td>
                <td><?php echo e($result->PatientType); ?> - (<?php echo e($OpdTypeName); ?>)</td>
                <td>
                    <?php if($UserId == 58): ?>
                        <a href="javascript:void(0);">
                            <?php echo e($result->Amount); ?> - (<?php echo e($PayMode); ?>)
                        </a>
                    <?php else: ?>
                        <?php echo e($result->Amount); ?> - (<?php echo e($PayMode); ?>)
                    <?php endif; ?>
                </td>
                <td><?php echo e($result->CreatedByName); ?></td>
                <td><?php echo e($result->ConsultName); ?></td>
                <td><?php echo e($result->InvStName); ?></td>
                    
                                 <td>
                                    <?php if($result->Checked == 1){?>
                                    <a href='javascript:void(0);' class="badge badge-pill badge-danger"
                                        onclick="backToQueue(<?php echo e($result->MrdNo); ?>,'<?php echo e($result->InDate); ?>')" style="background-color: rgb(65, 110, 110);font-size: 16px;border-radius: 0rem;">
                                        Back To Queue</a>
                                    <?php } ?>
                                    </td> 
                                
                               
                              
                            </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
    </div>
            </div>
        </div>
    </div>
    <div id="cover-spin"></div>
    <!-- customar project  end -->
</div>
<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><script src="<?php echo e(url('assets/js/jquery-3.6.0.min.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/jquery-3.6.0.min.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/js/bootstrap.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/bootstrap.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/js/sidenav.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/sidenav.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/js/layout-helpers.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/layout-helpers.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/js/material-ripple.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/material-ripple.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/perfect-scrollbar/perfect-scrollbar.js'))); ?>"></script>

    <script src="<?php echo e(url('assets/libs/datatables/datatables.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/datatables/datatables.js'))); ?>"></script>
    <script src="<?php echo e(url('assets/js/pages/tables_datatables.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/pages/tables_datatables.js'))); ?>"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#example').DataTable({
                responsive: true,
                pageLength: 50,
                scrollX: true,
                order: [[0, "asc"]]
            });
        });

        function backToQueue(MrdNo, VisitDate) {
            $('#cover-spin').show(0);
            $.ajax({
                url: "<?php echo e(url('backToQueue')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    MrdNo: MrdNo,
                    VisitDate: VisitDate
                },
                success: function(data) {
                    $('#cover-spin').hide(0);
                    alert("Patient Added in queue Successfully!");
                    window.close();
                    window.opener.location.reload();
                }
            });
        }
    </script><?php /**PATH C:\deshmukh_hosp\resources\views/opd/view-opd-queue-list.blade.php ENDPATH**/ ?>