<?php 
session_start();
require_once 'config.php';
require_once 'auth.php';
$MainPage="Master";
$Page = "Frequency-Master";
?>
<!DOCTYPE html>

<html lang="en" class="default-style">

<head>
    <title><?php echo $Proj_Title; ?></title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta name="description"
        content="" />
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes" />
    <?php include_once 'header_script.php'; ?>
</head>

<body>
    <!-- [ Preloader ] Start -->
    <div class="page-loader">
        <div class="bg-primary"></div>
    </div>
    <!-- [ Preloader ] End -->

    <!-- [ Layout wrapper ] Start -->
   <div class="layout-wrapper layout-1 layout-without-sidenav">
        <div class="layout-inner">
         
         <?php include 'sidenavi.php'; ?>

<div class="layout-container">
           
                 <div class="layout-content">
                    <div class="container-fluid flex-grow-1 container-p-y">
                        

                        <div class="row">
                            <!-- customar project  start -->
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row align-items-center m-l-0">
                                            
                                             
                                            
                                            <div class="col-sm-2 text-left">
                                                <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal" data-target="#modal-report"  id="add_button"><i class="feather icon-plus"></i> Add Frequency</button>
                                            </div>
                                           
                                           
                                        </div>
                                        <hr>
                                        <div class="table-responsive" id="custresult">
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- customar project  end -->
                        </div>
                    </div>
                    <!-- [ content ] End -->
                    <!-- [ Layout footer ] Start -->
                   <?php include 'footer.php'; ?>
                    <!-- [ Layout footer ] End -->
                </div>

                
                <!-- [ Layout content ] Start -->
            </div>
            <!-- [ Layout container ] End -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-sidenav-toggle"></div>
    </div>


    <!-- [ Layout wrapper] End -->
    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 70rem; ">
        <div class="modal-content">
          
            
            <div class="modal-header">
                <h5 class="modal-title">Add Frequency</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
               <form id="validation-form" method="POST">
                    <div class="row">
                       
                        <input type="hidden" name="action" id="action" value="Save">
                       <input type="hidden" name="id" id="id" /> 
                         <div class="col-sm-4">
                            <div class="form-group">
                                <label class="floating-label" for="Name">Frequency <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="FreqName" id="FreqName" placeholder="" required="">
                            </div>
                        </div>
                        
                       
                    
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Morning <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="Morning" id="Morning" placeholder="" required="">
                            </div>
                        </div>   

                         <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Afternoon <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="Afternoon" id="Afternoon" placeholder="" required="">
                            </div>
                        </div>   

                         <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Evening <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="Evening" id="Evening" placeholder="" required="">
                            </div>
                        </div>                      
                                                                                             
                        
                        <div class="col-sm-12">
                            <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<?php include_once 'footer_script.php'; ?>
<script type="text/javascript">
     function isNumberKey(evt){ 
    var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast(){
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
   $.growl.notice({
      title:    'Success',
      message:  'New Frequency Added Successfully!',
      location: isRtl ? 'tl' : 'tr'
    });
  }
  function error_toast(){
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
   $.growl.error({
      title:    'Error',
      message:  'Frequency Already Exists',
      location: isRtl ? 'tl' : 'tr'
    });
  }

  function procedure_lists(){
  var action = 'view';
      $.ajax({
  type: "POST",
  url: "ajax_files/ajax_frequency.php",
   data:{action:action},  
  success: function(data){
      $('#custresult').html(data);
  }
  });
    }

     $(document).ready(function() {
        procedure_lists();

        $('#add_button').click(function(){  
           $('.modal-title').html("Add <span class='font-weight-light'>New Frequency</span>");  
           $('#action').val("Save");  
           $('#id').val('');

     $('#FreqName').val('');  
                $('#Morning').val('');
                $('#Afternoon').val('');
                $('#Evening').val('');
       $('#submit').text('Submit');
          
      }) 

      $('#validation-form').on('submit', function(e){
      e.preventDefault();  
          if ($('#validation-form').valid()){ 
         $.ajax({  
                url :"ajax_files/ajax_frequency.php",  
                method:"POST",  
                data:new FormData(this),  
                contentType:false,  
                processData:false,  
                 beforeSend:function(){
     $('#submit').attr('disabled','disabled');
     $('#submit').text('Please Wait...');
    },
                success:function(data){ 
                    //alert(data);
                    if(data == 1){
                        $('#modal-report').modal('hide'); 
                         success_toast();
                         procedure_lists();
                        
                    }
                    else{
                        error_toast();
                        $('#modal-report').modal('show'); 
                    }
                     $('#submit').attr('disabled',false);
                       $('#submit').text('Submit');
                }
                });
     }
      });


      $(document).on("click", ".update", function(event){
 event.preventDefault();
 event.stopPropagation();
 var id = $(this).attr("data-id");
 var action = "fetch_record";
 $.ajax({  
                url:"ajax_files/ajax_frequency.php",  
                method:"POST",  
                data:{action:action,id:id},  
                dataType:"json",  
                success:function(data){  
                 $('#FreqName').val(data.FreqName);  
                $('#Morning').val(data.Morning);
                $('#Afternoon').val(data.Afternoon);
                $('#Evening').val(data.Evening);
                $('#action').val('Edit'); 
                   
                       $('#id').val(id);  
                       $('#submit').text("Update");   
                       $('#modal-report').modal('show');
                         $('.modal-title').html("Update <span class='font-weight-light'>Frequency</span>"); 
                     
                }  
           });
});



 $(document).on("click", ".delete", function(event){
 event.preventDefault();
 var id = $(this).attr("data-id");
 var action = "delete";
 //alert(id);
   swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Frequency!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                 $.ajax({  
                url:"ajax_files/ajax_frequency.php",  
                method:"POST",  
                data:{action:action,id:id},  
               
                success:function(data){
              swal("Deleted!", "Frequency has been deleted.", "success");
              
              procedure_lists();

                     }  
           });
                
            } else {
                swal("Cancelled", "Frequency is safe :)", "error");
            }
        });

           
 });
    }); 
</script>
</body>

</html>
