<?php 
session_start();
require_once 'config.php';
require_once 'auth.php';
$MainPage="Report";
$Page = "OPD-Month-Wise-Report";

// ---------- DATE FILTER ----------
$FromDate = $_REQUEST['FromDate'] ?? '';
$ToDate   = $_REQUEST['ToDate'] ?? '';

$where = "WHERE Status = 1";

if($FromDate != '' && $ToDate != ''){
    $where .= " AND VisitDate BETWEEN '$FromDate' AND '$ToDate'";
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Month Wise OPD Patient Report</title>

<style>
body{
    font-family: Roboto;
    font-size:12px;
}

.table{
    border-collapse:collapse;
    width:100%;
}
.table th,.table td{
    border:1px solid #000;
    padding:6px;
    text-align:center;
}

.table th{
    background:#ccc;
    font-weight:bold;
}

.noPrint{
    margin-bottom:10px;
}

@media print {
    .noPrint { display:none; }
}
</style>
</head>

<body>

<!-- ================= FILTER FORM ================= -->
<form method="get" class="noPrint" style="margin-bottom:15px;">
    From Date :
    <input type="date" name="FromDate" value="<?php echo $FromDate; ?>" required>

    To Date :
    <input type="date" name="ToDate" value="<?php echo $ToDate; ?>" required>

    <button type="submit">Search</button>
    <button onclick="window.print()" type="button">Print</button>
</form>

<h3 align="center">MONTH WISE OPD PATIENT COUNT REPORT</h3>

<?php if($FromDate && $ToDate){ ?>
<p align="center">
    <b>From:</b> <?php echo date("d/m/Y",strtotime($FromDate)); ?>
    &nbsp; | &nbsp;
    <b>To:</b> <?php echo date("d/m/Y",strtotime($ToDate)); ?>
</p>
<?php } ?>

<?php
// ---------- FETCH FILTERED MONTH WISE COUNT ----------
$sql = "
    SELECT 
        YEAR(VisitDate) AS report_year,
        MONTH(VisitDate) AS report_month,
        COUNT(*) AS total_patients
    FROM tbl_consultant
    $where
    GROUP BY YEAR(VisitDate), MONTH(VisitDate)
    ORDER BY report_year, report_month
";

$data = getList($sql);

// ---------- MONTH ARRAY ----------
$monthNames = [
  1=>'Jan',2=>'Feb',3=>'Mar',4=>'Apr',5=>'May',6=>'Jun',
  7=>'Jul',8=>'Aug',9=>'Sep',10=>'Oct',11=>'Nov',12=>'Dec'
];

// ---------- FORMAT DATA ----------
$final = [];

foreach($data as $row){
    $year  = $row['report_year'];
    $month = $row['report_month'];
    $count = $row['total_patients'];

    if(!isset($final[$year])){
        foreach($monthNames as $m){
            $final[$year][$m] = 0;
        }
    }

    $final[$year][$monthNames[$month]] = $count;
}
?>

<table class="table">
<tr>
    <th>Year</th>
    <?php foreach($monthNames as $m){ ?>
        <th><?php echo $m; ?></th>
    <?php } ?>
    <th>Total</th>
</tr>

<?php if(!empty($final)){ ?>
<?php foreach($final as $year => $months){ 
    $yearTotal = array_sum($months);
?>
<tr>
    <td><b><?php echo $year; ?></b></td>
    <?php foreach($months as $cnt){ ?>
        <td><?php echo $cnt; ?></td>
    <?php } ?>
    <td><b><?php echo $yearTotal; ?></b></td>
</tr>
<?php } ?>
<?php } else { ?>
<tr>
    <td colspan="14" align="center"><b>No Data Found For Selected Dates</b></td>
</tr>
<?php } ?>

</table>

<br>
<p><b>Report Generated On:</b> <?php echo date("d/m/Y h:i A"); ?></p>

</body>
</html>
